/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.ICodeCache;
import jadx.api.utils.tasks.ITaskExecutor;
import jadx.gui.JadxWrapper;
import jadx.gui.cache.code.CodeCacheMode;
import jadx.gui.cache.code.FixedCodeCache;
import jadx.gui.jobs.CancelableBackgroundTask;
import jadx.gui.jobs.DecompileTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import java.io.File;
import javax.swing.JOptionPane;

public class ExportTask
extends CancelableBackgroundTask {
    private final MainWindow mainWindow;
    private final JadxWrapper wrapper;
    private final File saveDir;
    private int timeLimit;
    private ICodeCache uiCodeCache;

    public ExportTask(MainWindow mainWindow, JadxWrapper wrapper, File saveDir) {
        this.mainWindow = mainWindow;
        this.wrapper = wrapper;
        this.saveDir = saveDir;
    }

    @Override
    public String getTitle() {
        return NLS.str("msg.saving_sources");
    }

    @Override
    public ITaskExecutor scheduleTasks() {
        this.wrapCodeCache();
        this.wrapper.getArgs().setRootDir(this.saveDir);
        ITaskExecutor saveTasks = this.wrapper.getDecompiler().getSaveTaskExecutor();
        this.timeLimit = DecompileTask.calcDecompileTimeLimit(saveTasks.getTasksCount());
        return saveTasks;
    }

    private void wrapCodeCache() {
        this.uiCodeCache = this.wrapper.getArgs().getCodeCache();
        if (this.mainWindow.getSettings().getCodeCacheMode() != CodeCacheMode.DISK) {
            this.wrapper.getArgs().setCodeCache(new FixedCodeCache(this.uiCodeCache));
        }
    }

    @Override
    public void onFinish(ITaskInfo taskInfo) {
        this.wrapper.getArgs().setCodeCache(this.uiCodeCache);
        if (taskInfo.getJobsSkipped() == 0L) {
            return;
        }
        String reason = this.getIncompleteReason(taskInfo.getStatus());
        if (reason != null) {
            JOptionPane.showMessageDialog(this.mainWindow, NLS.str("message.saveIncomplete", reason, taskInfo.getJobsSkipped()), NLS.str("message.errorTitle"), 0);
        }
    }

    private String getIncompleteReason(TaskStatus status) {
        switch (status) {
            case CANCEL_BY_USER: {
                return NLS.str("message.userCancelTask");
            }
            case CANCEL_BY_TIMEOUT: {
                return NLS.str("message.taskTimeout", this.timeLimit());
            }
            case CANCEL_BY_MEMORY: {
                this.mainWindow.showHeapUsageBar();
                return NLS.str("message.memoryLow");
            }
            case ERROR: {
                return NLS.str("message.taskError");
            }
        }
        return null;
    }

    @Override
    public int timeLimit() {
        return this.timeLimit;
    }

    @Override
    public boolean canBeCanceled() {
        return true;
    }

    @Override
    public boolean checkMemoryUsage() {
        return true;
    }
}

