/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ICodeInfo;
import jadx.api.ResourceFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ResContainer
implements Comparable<ResContainer> {
    private final DataType dataType;
    private final String name;
    private final Object data;
    private final List<ResContainer> subFiles;

    public static ResContainer textResource(String name, ICodeInfo content) {
        return new ResContainer(name, Collections.emptyList(), content, DataType.TEXT);
    }

    public static ResContainer decodedData(String name, byte[] data) {
        return new ResContainer(name, Collections.emptyList(), data, DataType.DECODED_DATA);
    }

    public static ResContainer resourceFileLink(ResourceFile resFile) {
        return new ResContainer(resFile.getDeobfName(), Collections.emptyList(), resFile, DataType.RES_LINK);
    }

    public static ResContainer resourceTable(String name, List<ResContainer> subFiles, ICodeInfo rootContent) {
        return new ResContainer(name, subFiles, rootContent, DataType.RES_TABLE);
    }

    private ResContainer(String name, List<ResContainer> subFiles, Object data, DataType dataType) {
        this.name = Objects.requireNonNull(name);
        this.subFiles = Objects.requireNonNull(subFiles);
        this.data = Objects.requireNonNull(data);
        this.dataType = Objects.requireNonNull(dataType);
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.name.replace('/', File.separatorChar);
    }

    public List<ResContainer> getSubFiles() {
        return this.subFiles;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public ICodeInfo getText() {
        return (ICodeInfo)this.data;
    }

    public byte[] getDecodedData() {
        return (byte[])this.data;
    }

    public ResourceFile getResLink() {
        return (ResourceFile)this.data;
    }

    @Override
    public int compareTo(@NotNull ResContainer o15) {
        return this.name.compareTo(o15.name);
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof ResContainer)) {
            return false;
        }
        ResContainer that = (ResContainer)o15;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Res{" + this.name + ", type=" + String.valueOf((Object)this.dataType) + ", subFiles=" + String.valueOf(this.subFiles) + "}";
    }

    public static enum DataType {
        TEXT,
        DECODED_DATA,
        RES_LINK,
        RES_TABLE;

    }
}

