/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class ImmutableList<E>
implements List<E>,
RandomAccess {
    private final E[] arr;

    public ImmutableList(Collection<E> col) {
        this(Objects.requireNonNull(col).toArray());
    }

    public ImmutableList(E[] arr) {
        this.arr = Objects.requireNonNull(arr);
    }

    @Override
    public int size() {
        return this.arr.length;
    }

    @Override
    public boolean isEmpty() {
        return this.arr.length == 0;
    }

    @Override
    public E get(int index) {
        return this.arr[index];
    }

    @Override
    public int indexOf(Object o15) {
        int len = this.arr.length;
        for (int i15 = 0; i15 < len; ++i15) {
            E e15 = this.arr[i15];
            if (!Objects.equals(e15, o15)) continue;
            return i15;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o15) {
        for (int i15 = this.arr.length - 1; i15 > 0; --i15) {
            E e15 = this.arr[i15];
            if (!Objects.equals(e15, o15)) continue;
            return i15;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o15) {
        return this.indexOf(o15) != -1;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c15) {
        for (Object obj : c15) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final int len;
            private int index;
            {
                this.len = ImmutableList.this.arr.length;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.len;
            }

            @Override
            public E next() {
                try {
                    return ImmutableList.this.arr[this.index++];
                }
                catch (IndexOutOfBoundsException e15) {
                    throw new NoSuchElementException(e15.getMessage());
                }
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        for (E e15 : this.arr) {
            action.accept(e15);
        }
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return Arrays.copyOf(this.arr, this.arr.length);
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a15) {
        return Arrays.copyOf(this.arr, this.arr.length);
    }

    @Override
    public boolean add(E e15) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o15) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c15) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c15) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c15) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c15) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super E> c15) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 instanceof ImmutableList) {
            ImmutableList other = (ImmutableList)o15;
            return Arrays.equals(this.arr, other.arr);
        }
        if (o15 instanceof List) {
            List other = (List)o15;
            int size = this.size();
            if (size != other.size()) {
                return false;
            }
            for (int i15 = 0; i15 < size; ++i15) {
                E e15 = this.arr[i15];
                Object e25 = other.get(i15);
                if (Objects.equals(e15, e25)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    public String toString() {
        return "ImmutableList{" + Arrays.toString(this.arr) + "}";
    }
}

