/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.variables;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.DeclareVariablesAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.variables.CollectUsageRegionVisitor;
import jadx.core.dex.visitors.regions.variables.UsePlace;
import jadx.core.dex.visitors.regions.variables.VarUsage;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.utils.ListUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessVariables
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessVariables.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode() || mth.getSVars().isEmpty()) {
            return;
        }
        ProcessVariables.removeUnusedResults(mth);
        List<CodeVar> codeVars = this.collectCodeVars(mth);
        if (codeVars.isEmpty()) {
            return;
        }
        this.checkCodeVars(mth, codeVars);
        CollectUsageRegionVisitor usageCollector = new CollectUsageRegionVisitor();
        DepthRegionTraversal.traverse(mth, usageCollector);
        Map<SSAVar, VarUsage> ssaUsageMap = usageCollector.getUsageMap();
        if (ssaUsageMap.isEmpty()) {
            return;
        }
        Map<CodeVar, List<VarUsage>> codeVarUsage = this.mergeUsageMaps(codeVars, ssaUsageMap);
        for (Map.Entry<CodeVar, List<VarUsage>> entry : codeVarUsage.entrySet()) {
            this.declareVar(mth, entry.getKey(), entry.getValue());
        }
    }

    private static void removeUnusedResults(MethodNode mth) {
        DepthRegionTraversal.traverse(mth, new AbstractRegionVisitor(){

            @Override
            public void processBlock(MethodNode mth, IBlock container) {
                for (InsnNode insn : container.getInstructions()) {
                    SSAVar ssaVar;
                    RegisterArg resultArg = insn.getResult();
                    if (resultArg == null || !this.isVarUnused(mth, ssaVar = resultArg.getSVar())) continue;
                    boolean remove = false;
                    if (insn.canRemoveResult()) {
                        remove = true;
                    } else if (this.canRemoveInsn(insn)) {
                        insn.add(AFlag.REMOVE);
                        insn.add(AFlag.DONT_GENERATE);
                        remove = true;
                    }
                    if (!remove) continue;
                    insn.setResult(null);
                    mth.removeSVar(ssaVar);
                    for (RegisterArg arg : ssaVar.getUseList()) {
                        arg.resetSSAVar();
                    }
                }
            }

            private boolean canRemoveInsn(InsnNode insn) {
                if (insn.isConstInsn()) {
                    return true;
                }
                switch (insn.getType()) {
                    case CAST: 
                    case CHECK_CAST: {
                        return true;
                    }
                }
                return false;
            }

            private boolean isVarUnused(MethodNode mth, @Nullable SSAVar ssaVar) {
                if (ssaVar == null) {
                    return true;
                }
                List<RegisterArg> useList = ssaVar.getUseList();
                if (useList.isEmpty()) {
                    return true;
                }
                if (ssaVar.isUsedInPhi()) {
                    return false;
                }
                return ListUtils.allMatch(useList, arg -> this.isArgUnused(mth, (RegisterArg)arg));
            }

            private boolean isArgUnused(MethodNode mth, RegisterArg arg) {
                MethodNode resolveMth;
                if (arg.contains(AFlag.REMOVE)) {
                    return true;
                }
                InsnNode parentInsn = arg.getParentInsn();
                if (parentInsn != null && parentInsn.getType() == InsnType.CONSTRUCTOR && parentInsn.contains(AType.METHOD_DETAILS) && (resolveMth = mth.root().getMethodUtils().resolveMethod((ConstructorInsn)parentInsn)) != null && resolveMth.contains(AType.SKIP_MTH_ARGS)) {
                    RegisterArg mthArg;
                    int insnPos = parentInsn.getArgIndex(arg);
                    List<RegisterArg> mthArgs = resolveMth.getArgRegs();
                    if (0 <= insnPos && insnPos < mthArgs.size() && (mthArg = mthArgs.get(insnPos)).contains(AFlag.REMOVE) && arg.sameType(mthArg)) {
                        arg.add(AFlag.DONT_GENERATE);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private void checkCodeVars(MethodNode mth, List<CodeVar> codeVars) {
        int unknownTypesCount = 0;
        for (CodeVar codeVar : codeVars) {
            ArgType codeVarType = codeVar.getType();
            if (codeVarType == null) {
                codeVar.setType(ArgType.UNKNOWN);
                ++unknownTypesCount;
                continue;
            }
            codeVar.getSsaVars().forEach(ssaVar -> {
                TypeCompare comparator;
                TypeCompareEnum result;
                ArgType ssaType = ssaVar.getImmutableType();
                if (ssaType != null && ssaType.isTypeKnown() && ((result = (comparator = mth.root().getTypeUpdate().getTypeCompare()).compareTypes(ssaType, codeVarType)) == TypeCompareEnum.CONFLICT || result.isNarrow())) {
                    mth.addWarn("Incorrect type for immutable var: ssa=" + String.valueOf(ssaType) + ", code=" + String.valueOf(codeVarType) + ", for " + ssaVar.getDetailedVarInfo(mth));
                }
            });
        }
        if (unknownTypesCount != 0) {
            mth.addWarn("Unknown variable types count: " + unknownTypesCount);
        }
    }

    private void declareVar(MethodNode mth, CodeVar codeVar, List<VarUsage> usageList) {
        if (codeVar.isDeclared()) {
            return;
        }
        VarUsage mergedUsage = new VarUsage(null);
        for (VarUsage varUsage : usageList) {
            mergedUsage.getAssigns().addAll(varUsage.getAssigns());
            mergedUsage.getUses().addAll(varUsage.getUses());
        }
        if (mergedUsage.getAssigns().isEmpty() && mergedUsage.getUses().isEmpty()) {
            return;
        }
        if (this.checkDeclareAtAssign(usageList, mergedUsage)) {
            return;
        }
        ProcessVariables.declareVarInRegion(mth.getRegion(), codeVar);
    }

    private List<CodeVar> collectCodeVars(MethodNode mth) {
        CodeVar codeVar;
        LinkedHashMap<CodeVar, List> codeVars = new LinkedHashMap<CodeVar, List>();
        for (SSAVar sSAVar : mth.getSVars()) {
            if (sSAVar.getCodeVar().isThis()) continue;
            codeVar = sSAVar.getCodeVar();
            List list2 = codeVars.computeIfAbsent(codeVar, k15 -> new ArrayList());
            list2.add(sSAVar);
        }
        for (Map.Entry entry : codeVars.entrySet()) {
            codeVar = (CodeVar)entry.getKey();
            List list2 = (List)entry.getValue();
            for (SSAVar ssaVar : list2) {
                CodeVar localCodeVar = ssaVar.getCodeVar();
                codeVar.mergeFlagsFrom(localCodeVar);
            }
            if (list2.size() > 1) {
                for (SSAVar ssaVar : list2) {
                    ssaVar.setCodeVar(codeVar);
                }
            }
            codeVar.setSsaVars(list2);
        }
        return new ArrayList<CodeVar>(codeVars.keySet());
    }

    private Map<CodeVar, List<VarUsage>> mergeUsageMaps(List<CodeVar> codeVars, Map<SSAVar, VarUsage> ssaUsageMap) {
        LinkedHashMap<CodeVar, List<VarUsage>> codeVarUsage = new LinkedHashMap<CodeVar, List<VarUsage>>(codeVars.size());
        for (CodeVar codeVar : codeVars) {
            ArrayList<VarUsage> list2 = new ArrayList<VarUsage>();
            for (SSAVar ssaVar : codeVar.getSsaVars()) {
                VarUsage usage = ssaUsageMap.get(ssaVar);
                if (usage == null) continue;
                list2.add(usage);
            }
            codeVarUsage.put(codeVar, Utils.lockList(list2));
        }
        return codeVarUsage;
    }

    private boolean checkDeclareAtAssign(List<VarUsage> list2, VarUsage mergedUsage) {
        if (mergedUsage.getAssigns().isEmpty()) {
            return false;
        }
        for (VarUsage u15 : list2) {
            for (UsePlace assign : u15.getAssigns()) {
                if (!ProcessVariables.canDeclareAt(mergedUsage, assign)) continue;
                return ProcessVariables.checkDeclareAtAssign(u15.getVar());
            }
        }
        return false;
    }

    private static boolean canDeclareAt(VarUsage usage, UsePlace usePlace) {
        IRegion region = usePlace.getRegion();
        if (region instanceof LoopRegion) {
            for (UsePlace use : usage.getAssigns()) {
                if (RegionUtils.isRegionContainsRegion(region, use.getRegion())) continue;
                return false;
            }
        }
        if (region.contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        return ProcessVariables.isAllUseAfter(usePlace, usage.getAssigns()) && ProcessVariables.isAllUseAfter(usePlace, usage.getUses());
    }

    private static boolean isAllUseAfter(UsePlace checkPlace, List<UsePlace> usePlaces) {
        IRegion region = checkPlace.getRegion();
        IBlock block = checkPlace.getBlock();
        HashSet<UsePlace> toCheck = new HashSet<UsePlace>(usePlaces);
        boolean blockFound = false;
        for (IContainer subBlock : region.getSubBlocks()) {
            if (!blockFound && subBlock == block) {
                blockFound = true;
            }
            if (!blockFound) continue;
            toCheck.removeIf(usePlace -> ProcessVariables.isContainerContainsUsePlace(subBlock, usePlace));
            if (!toCheck.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean isContainerContainsUsePlace(IContainer subBlock, UsePlace usePlace) {
        if (subBlock == usePlace.getBlock()) {
            return true;
        }
        if (subBlock instanceof IRegion) {
            return RegionUtils.isRegionContainsRegion(subBlock, usePlace.getRegion());
        }
        return false;
    }

    private static boolean checkDeclareAtAssign(SSAVar var) {
        RegisterArg arg = var.getAssign();
        InsnNode parentInsn = arg.getParentInsn();
        if (parentInsn == null || parentInsn.contains(AFlag.WRAPPED) || parentInsn.getType() == InsnType.PHI) {
            return false;
        }
        if (!arg.equals(parentInsn.getResult())) {
            return false;
        }
        parentInsn.add(AFlag.DECLARE_VAR);
        var.getCodeVar().setDeclared(true);
        return true;
    }

    private static void declareVarInRegion(IContainer region, CodeVar var) {
        if (var.isDeclared()) {
            LOG.warn("Try to declare already declared variable: {}", (Object)var);
            return;
        }
        DeclareVariablesAttr dv4 = region.get(AType.DECLARE_VARIABLES);
        if (dv4 == null) {
            dv4 = new DeclareVariablesAttr();
            region.addAttr(dv4);
        }
        dv4.addVar(var);
        var.setDeclared(true);
    }
}

