/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.maker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.visitors.regions.CleanRegions;
import jadx.core.dex.visitors.regions.maker.RegionMaker;
import jadx.core.dex.visitors.regions.maker.RegionStack;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.Utils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedRegionMaker {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizedRegionMaker.class);
    private final MethodNode mth;
    private final RegionMaker regionMaker;

    SynchronizedRegionMaker(MethodNode mth, RegionMaker regionMaker) {
        this.mth = mth;
        this.regionMaker = regionMaker;
    }

    BlockNode process(IRegion curRegion, BlockNode block, InsnNode insn, RegionStack stack) {
        SynchronizedRegion synchRegion = new SynchronizedRegion(curRegion, insn);
        synchRegion.getSubBlocks().add(block);
        curRegion.getSubBlocks().add(synchRegion);
        LinkedHashSet<BlockNode> exits = new LinkedHashSet<BlockNode>();
        HashSet<BlockNode> cacheSet = new HashSet<BlockNode>();
        SynchronizedRegionMaker.traverseMonitorExits(synchRegion, insn.getArg(0), block, exits, cacheSet);
        for (InsnNode exitInsn : synchRegion.getExitInsns()) {
            BlockNode insnBlock = BlockUtils.getBlockByInsn(this.mth, exitInsn);
            if (insnBlock != null) {
                insnBlock.add(AFlag.DONT_GENERATE);
            }
            exitInsn.removeArg(0);
            exitInsn.add(AFlag.DONT_GENERATE);
        }
        BlockNode body = BlockUtils.getNextBlock(block);
        if (body == null) {
            this.mth.addWarn("Unexpected end of synchronized block");
            return null;
        }
        BlockNode exit = null;
        if (exits.size() == 1) {
            exit = BlockUtils.getNextBlock((BlockNode)exits.iterator().next());
        } else if (exits.size() > 1) {
            cacheSet.clear();
            exit = SynchronizedRegionMaker.traverseMonitorExitsCross(body, exits, cacheSet);
        }
        stack.push(synchRegion);
        if (exit != null) {
            stack.addExit(exit);
        } else {
            for (BlockNode exitBlock : exits) {
                List<BlockNode> list2 = BlockUtils.buildSimplePath(exitBlock);
                if (!list2.isEmpty() && BlockUtils.isExitBlock(this.mth, Utils.last(list2))) continue;
                stack.addExit(exitBlock);
                exit = exitBlock;
            }
        }
        synchRegion.getSubBlocks().add(this.regionMaker.makeRegion(body));
        stack.pop();
        return exit;
    }

    private static void traverseMonitorExits(SynchronizedRegion region, InsnArg arg, BlockNode block, Set<BlockNode> exits, Set<BlockNode> visited) {
        visited.add(block);
        for (InsnNode insn : block.getInstructions()) {
            if (insn.getType() != InsnType.MONITOR_EXIT || insn.getArgsCount() <= 0 || !insn.getArg(0).equals(arg)) continue;
            exits.add(block);
            region.getExitInsns().add(insn);
            return;
        }
        for (BlockNode node : block.getSuccessors()) {
            if (visited.contains(node)) continue;
            SynchronizedRegionMaker.traverseMonitorExits(region, arg, node, exits, visited);
        }
    }

    private static BlockNode traverseMonitorExitsCross(BlockNode block, Set<BlockNode> exits, Set<BlockNode> visited) {
        visited.add(block);
        for (BlockNode node : block.getCleanSuccessors()) {
            BlockNode res;
            boolean cross = true;
            for (BlockNode exitBlock : exits) {
                boolean p15 = BlockUtils.isPathExists(exitBlock, node);
                if (p15) continue;
                cross = false;
                break;
            }
            if (cross) {
                return node;
            }
            if (visited.contains(node) || (res = SynchronizedRegionMaker.traverseMonitorExitsCross(node, exits, visited)) == null) continue;
            return res;
        }
        return null;
    }

    public static void removeSynchronized(MethodNode mth) {
        SynchronizedRegion synchRegion;
        InsnNode syncInsn;
        Region startRegion = mth.getRegion();
        List<IContainer> subBlocks = startRegion.getSubBlocks();
        if (!subBlocks.isEmpty() && subBlocks.get(0) instanceof SynchronizedRegion && SynchronizedRegionMaker.canRemoveSyncBlock(mth, syncInsn = (synchRegion = (SynchronizedRegion)subBlocks.get(0)).getEnterInsn())) {
            startRegion.getSubBlocks().set(0, synchRegion.getRegion());
            InsnRemover.remove(mth, syncInsn);
            for (InsnNode exit : synchRegion.getExitInsns()) {
                InsnRemover.remove(mth, exit);
            }
            CleanRegions.process(mth);
        }
    }

    private static boolean canRemoveSyncBlock(MethodNode mth, InsnNode synchInsn) {
        InsnArg syncArg = synchInsn.getArg(0);
        if (mth.getAccessFlags().isStatic()) {
            ArgType clsType;
            InsnNode constInsn;
            if (syncArg.isInsnWrap() && syncArg.isConst() && (constInsn = syncArg.unwrap()).getType() == InsnType.CONST_CLASS && (clsType = ((ConstClassNode)constInsn).getClsType()).equals(mth.getParentClass().getType())) {
                return true;
            }
            mth.addWarnComment("In static synchronized method top region not synchronized by class const: " + String.valueOf(syncArg));
        } else {
            if (syncArg.isThis()) {
                return true;
            }
            mth.addWarnComment("In synchronized method top region not synchronized by 'this': " + String.valueOf(syncArg));
        }
        return false;
    }
}

