/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.plugins.input.data.ICatch;
import jadx.api.plugins.input.data.ITry;
import jadx.api.plugins.utils.Utils;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ProcessInstructionsVisitor;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Attach Try/Catch Visitor", desc="Attach try/catch info to instructions", runBefore={ProcessInstructionsVisitor.class})
public class AttachTryCatchVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(AttachTryCatchVisitor.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        AttachTryCatchVisitor.initTryCatches(mth, mth.getInstructions(), mth.getCodeReader().getTries());
    }

    private static void initTryCatches(MethodNode mth, InsnNode[] insnByOffset, List<ITry> tries) {
        if (tries.isEmpty()) {
            return;
        }
        for (ITry tryData : tries) {
            List<ExceptionHandler> handlers = AttachTryCatchVisitor.convertToHandlers(mth, tryData.getCatch(), insnByOffset);
            if (handlers.isEmpty()) continue;
            AttachTryCatchVisitor.markTryBounds(insnByOffset, tryData, CatchAttr.build(handlers));
        }
    }

    private static void markTryBounds(InsnNode[] insnByOffset, ITry aTry, CatchAttr catchAttr) {
        int offset = aTry.getStartOffset();
        int end = aTry.getEndOffset();
        boolean tryBlockStarted = false;
        AttrNode insn = null;
        while (offset <= end) {
            InsnNode insnAtOffset = insnByOffset[offset];
            if (insnAtOffset != null) {
                insn = insnAtOffset;
                AttachTryCatchVisitor.attachCatchAttr(catchAttr, (InsnNode)insn);
                if (!tryBlockStarted) {
                    insn.add(AFlag.TRY_ENTER);
                    tryBlockStarted = true;
                }
            }
            if ((offset = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset)) != -1) continue;
            break;
        }
        if (tryBlockStarted) {
            insn.add(AFlag.TRY_LEAVE);
        } else {
            InsnNode nop = AttachTryCatchVisitor.insertNOP(insnByOffset, aTry.getStartOffset());
            nop.add(AFlag.TRY_ENTER);
            nop.add(AFlag.TRY_LEAVE);
            nop.addAttr(catchAttr);
        }
    }

    private static void attachCatchAttr(CatchAttr catchAttr, InsnNode insn) {
        CatchAttr existAttr = insn.get(AType.EXC_CATCH);
        if (existAttr != null) {
            List<ExceptionHandler> handlers = Utils.concat(existAttr.getHandlers(), catchAttr.getHandlers());
            insn.addAttr(CatchAttr.build(handlers));
        } else {
            insn.addAttr(catchAttr);
        }
    }

    private static List<ExceptionHandler> convertToHandlers(MethodNode mth, ICatch catchBlock, InsnNode[] insnByOffset) {
        int[] handlerOffsetArr = catchBlock.getHandlers();
        String[] handlerTypes = catchBlock.getTypes();
        int handlersCount = handlerOffsetArr.length;
        ArrayList<ExceptionHandler> list2 = new ArrayList<ExceptionHandler>(handlersCount);
        for (int i15 = 0; i15 < handlersCount; ++i15) {
            int handlerOffset = handlerOffsetArr[i15];
            ClassInfo type = ClassInfo.fromName(mth.root(), handlerTypes[i15]);
            Utils.addToList(list2, AttachTryCatchVisitor.createHandler(mth, insnByOffset, handlerOffset, type));
        }
        int allHandlerOffset = catchBlock.getCatchAllHandler();
        if (allHandlerOffset >= 0) {
            Utils.addToList(list2, AttachTryCatchVisitor.createHandler(mth, insnByOffset, allHandlerOffset, null));
        }
        return list2;
    }

    @Nullable
    private static ExceptionHandler createHandler(MethodNode mth, InsnNode[] insnByOffset, int handlerOffset, @Nullable ClassInfo type) {
        InsnNode insn = insnByOffset[handlerOffset];
        if (insn != null) {
            ExcHandlerAttr excHandlerAttr = insn.get(AType.EXC_HANDLER);
            if (excHandlerAttr != null) {
                ExceptionHandler handler = excHandlerAttr.getHandler();
                if (handler.addCatchType(mth, type)) {
                    return null;
                }
                return handler;
            }
        } else {
            insn = AttachTryCatchVisitor.insertNOP(insnByOffset, handlerOffset);
        }
        ExceptionHandler handler = ExceptionHandler.build(mth, handlerOffset, type);
        mth.addExceptionHandler(handler);
        insn.addAttr(new ExcHandlerAttr(handler));
        return handler;
    }

    private static InsnNode insertNOP(InsnNode[] insnByOffset, int offset) {
        InsnNode nop = new InsnNode(InsnType.NOP, 0);
        nop.setOffset(offset);
        nop.add(AFlag.SYNTHETIC);
        insnByOffset[offset] = nop;
        return nop;
    }

    private static /* synthetic */ void lambda$initTryCatches$0(ITry tryData) {
        LOG.debug(" - {}", (Object)tryData);
    }
}

