/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.conditions;

import jadx.api.ICodeWriter;
import jadx.core.codegen.RegionGen;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.regions.conditions.ConditionRegion;
import jadx.core.utils.exceptions.CodegenException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IfRegion
extends ConditionRegion
implements IBranchRegion {
    private IContainer thenRegion;
    private IContainer elseRegion;

    public IfRegion(IRegion parent) {
        super(parent);
    }

    public IContainer getThenRegion() {
        return this.thenRegion;
    }

    public void setThenRegion(IContainer thenRegion) {
        this.thenRegion = thenRegion;
    }

    public IContainer getElseRegion() {
        return this.elseRegion;
    }

    public void setElseRegion(IContainer elseRegion) {
        this.elseRegion = elseRegion;
    }

    public void invert() {
        this.invertCondition();
        IContainer tmp = this.thenRegion;
        this.thenRegion = this.elseRegion;
        this.elseRegion = tmp;
    }

    public int getSourceLine() {
        return this.getConditionSourceLine();
    }

    @Override
    public List<IContainer> getSubBlocks() {
        List<BlockNode> conditionBlocks = this.getConditionBlocks();
        ArrayList<IContainer> all = new ArrayList<IContainer>(conditionBlocks.size() + 2);
        all.addAll(conditionBlocks);
        if (this.thenRegion != null) {
            all.add(this.thenRegion);
        }
        if (this.elseRegion != null) {
            all.add(this.elseRegion);
        }
        return Collections.unmodifiableList(all);
    }

    @Override
    public List<IContainer> getBranches() {
        ArrayList<IContainer> branches = new ArrayList<IContainer>(2);
        branches.add(this.thenRegion);
        branches.add(this.elseRegion);
        return Collections.unmodifiableList(branches);
    }

    @Override
    public boolean replaceSubBlock(IContainer oldBlock, IContainer newBlock) {
        if (oldBlock == this.thenRegion) {
            this.thenRegion = newBlock;
            this.updateParent(this.thenRegion, this);
            return true;
        }
        if (oldBlock == this.elseRegion) {
            this.elseRegion = newBlock;
            this.updateParent(this.elseRegion, this);
            return true;
        }
        return false;
    }

    @Override
    public void generate(RegionGen regionGen, ICodeWriter code) throws CodegenException {
        regionGen.makeIf(this, code, true);
    }

    @Override
    public String baseString() {
        StringBuilder sb5 = new StringBuilder();
        if (this.thenRegion != null) {
            sb5.append(this.thenRegion.baseString());
        }
        if (this.elseRegion != null) {
            sb5.append(this.elseRegion.baseString());
        }
        return sb5.toString();
    }

    public String toString() {
        return "IF " + String.valueOf(this.getConditionBlocks()) + " THEN: " + String.valueOf(this.thenRegion) + " ELSE: " + String.valueOf(this.elseRegion);
    }
}

