/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.conditions;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.utils.blocks.BlockSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IfInfo {
    private final MethodNode mth;
    private final IfCondition condition;
    private final BlockSet mergedBlocks;
    private final BlockNode thenBlock;
    private final BlockNode elseBlock;
    private final Set<BlockNode> skipBlocks;
    private final List<InsnNode> forceInlineInsns;
    private BlockNode outBlock;

    public IfInfo(MethodNode mth, IfCondition condition2, BlockNode thenBlock, BlockNode elseBlock) {
        this(mth, condition2, thenBlock, elseBlock, BlockSet.empty(mth), new HashSet<BlockNode>(), new ArrayList<InsnNode>());
    }

    public IfInfo(IfInfo info, BlockNode thenBlock, BlockNode elseBlock) {
        this(info.getMth(), info.getCondition(), thenBlock, elseBlock, info.getMergedBlocks(), info.getSkipBlocks(), info.getForceInlineInsns());
    }

    private IfInfo(MethodNode mth, IfCondition condition2, BlockNode thenBlock, BlockNode elseBlock, BlockSet mergedBlocks, Set<BlockNode> skipBlocks, List<InsnNode> forceInlineInsns) {
        this.mth = mth;
        this.condition = condition2;
        this.thenBlock = thenBlock;
        this.elseBlock = elseBlock;
        this.mergedBlocks = mergedBlocks;
        this.skipBlocks = skipBlocks;
        this.forceInlineInsns = forceInlineInsns;
    }

    public static IfInfo invert(IfInfo info) {
        return new IfInfo(info.getMth(), IfCondition.invert(info.getCondition()), info.getElseBlock(), info.getThenBlock(), info.getMergedBlocks(), info.getSkipBlocks(), info.getForceInlineInsns());
    }

    public void merge(IfInfo ... arr) {
        for (IfInfo info : arr) {
            this.mergedBlocks.addAll(info.getMergedBlocks());
            this.skipBlocks.addAll(info.getSkipBlocks());
            this.addInsnsForForcedInline(info.getForceInlineInsns());
        }
    }

    @Deprecated
    public BlockNode getFirstIfBlock() {
        return this.mergedBlocks.getFirst();
    }

    public BlockSet getMergedBlocks() {
        return this.mergedBlocks;
    }

    public MethodNode getMth() {
        return this.mth;
    }

    public IfCondition getCondition() {
        return this.condition;
    }

    public Set<BlockNode> getSkipBlocks() {
        return this.skipBlocks;
    }

    public BlockNode getThenBlock() {
        return this.thenBlock;
    }

    public BlockNode getElseBlock() {
        return this.elseBlock;
    }

    public BlockNode getOutBlock() {
        return this.outBlock;
    }

    public void setOutBlock(BlockNode outBlock) {
        this.outBlock = outBlock;
    }

    public List<InsnNode> getForceInlineInsns() {
        return this.forceInlineInsns;
    }

    public void resetForceInlineInsns() {
        this.forceInlineInsns.clear();
    }

    public void addInsnsForForcedInline(List<InsnNode> insns) {
        this.forceInlineInsns.addAll(insns);
    }

    public String toString() {
        return "IfInfo: then: " + String.valueOf(this.thenBlock) + ", else: " + String.valueOf(this.elseBlock);
    }
}

