/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.conditions;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IConditionRegion;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.conditions.IfInfo;
import jadx.core.utils.BlockUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ConditionRegion
extends AbstractRegion
implements IConditionRegion {
    @Nullable
    private IfCondition condition;
    private List<BlockNode> conditionBlocks = Collections.emptyList();

    public ConditionRegion(IRegion parent) {
        super(parent);
    }

    @Override
    @Nullable
    public IfCondition getCondition() {
        return this.condition;
    }

    @Override
    public List<BlockNode> getConditionBlocks() {
        return this.conditionBlocks;
    }

    @Override
    public void invertCondition() {
        if (this.condition != null) {
            this.condition = IfCondition.invert(this.condition);
        }
    }

    @Override
    public boolean simplifyCondition() {
        if (this.condition == null) {
            return false;
        }
        IfCondition updated = IfCondition.simplify(this.condition);
        if (updated != this.condition) {
            this.condition = updated;
            return true;
        }
        return false;
    }

    @Override
    public int getConditionSourceLine() {
        for (BlockNode block : this.conditionBlocks) {
            int sourceLine;
            InsnNode lastInsn = BlockUtils.getLastInsn(block);
            if (lastInsn == null || (sourceLine = lastInsn.getSourceLine()) == 0) continue;
            return sourceLine;
        }
        return 0;
    }

    public void updateCondition(IfInfo info) {
        this.condition = info.getCondition();
        this.conditionBlocks = info.getMergedBlocks().toList();
    }

    public void updateCondition(IfCondition condition2, List<BlockNode> conditionBlocks) {
        this.condition = condition2;
        this.conditionBlocks = conditionBlocks;
    }

    public void updateCondition(BlockNode block) {
        this.condition = IfCondition.fromIfBlock(block);
        this.conditionBlocks = Collections.singletonList(block);
    }
}

