/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions;

import jadx.api.ICodeWriter;
import jadx.core.codegen.RegionGen;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TryCatchRegion
extends AbstractRegion
implements IBranchRegion {
    private final IContainer tryRegion;
    private Map<ExceptionHandler, IContainer> catchRegions = Collections.emptyMap();
    private IContainer finallyRegion;
    private TryCatchBlockAttr tryCatchBlock;

    public TryCatchRegion(IRegion parent, IContainer tryRegion) {
        super(parent);
        this.tryRegion = tryRegion;
    }

    public void setTryCatchBlock(TryCatchBlockAttr tryCatchBlock) {
        this.tryCatchBlock = tryCatchBlock;
        int count = tryCatchBlock.getHandlersCount();
        this.catchRegions = new LinkedHashMap<ExceptionHandler, IContainer>(count);
        for (ExceptionHandler handler : tryCatchBlock.getHandlers()) {
            IContainer handlerRegion = handler.getHandlerRegion();
            if (handlerRegion == null) continue;
            if (handler.isFinally()) {
                this.finallyRegion = handlerRegion;
                continue;
            }
            this.catchRegions.put(handler, handlerRegion);
        }
    }

    public IContainer getTryRegion() {
        return this.tryRegion;
    }

    public Map<ExceptionHandler, IContainer> getCatchRegions() {
        return this.catchRegions;
    }

    public TryCatchBlockAttr getTryCatchBlock() {
        return this.tryCatchBlock;
    }

    public IContainer getFinallyRegion() {
        return this.finallyRegion;
    }

    public void setFinallyRegion(IContainer finallyRegion) {
        this.finallyRegion = finallyRegion;
    }

    @Override
    public List<IContainer> getSubBlocks() {
        ArrayList<IContainer> all = new ArrayList<IContainer>(2 + this.catchRegions.size());
        all.add(this.tryRegion);
        all.addAll(this.catchRegions.values());
        if (this.finallyRegion != null) {
            all.add(this.finallyRegion);
        }
        return Collections.unmodifiableList(all);
    }

    @Override
    public List<IContainer> getBranches() {
        return this.getSubBlocks();
    }

    @Override
    public void generate(RegionGen regionGen, ICodeWriter code) throws CodegenException {
        regionGen.makeTryCatch(this, code);
    }

    @Override
    public String baseString() {
        return this.tryRegion.baseString();
    }

    public String toString() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append("Try: ").append(this.tryRegion);
        if (!this.catchRegions.isEmpty()) {
            sb5.append(" catches: ").append(Utils.listToString(this.catchRegions.values()));
        }
        if (this.finallyRegion != null) {
            sb5.append(" finally: ").append(this.finallyRegion);
        }
        return sb5.toString();
    }
}

