/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.insns.custom.ISwitchPayload;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;

public class SwitchData
extends InsnNode {
    private final int size;
    private final int[] keys;
    private final int[] targets;

    public SwitchData(ISwitchPayload payload) {
        super(InsnType.SWITCH_DATA, 0);
        this.size = payload.getSize();
        this.keys = payload.getKeys();
        this.targets = payload.getTargets();
    }

    public void fixTargets(int switchOffset) {
        int size = this.size;
        int[] targets = this.targets;
        int i15 = 0;
        while (i15 < size) {
            int n15 = i15++;
            targets[n15] = targets[n15] + switchOffset;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getTargets() {
        return this.targets;
    }

    @Override
    public String toString() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append("switch-data {");
        for (int i15 = 0; i15 < this.size; ++i15) {
            sb5.append(this.keys[i15]).append("->").append(InsnUtils.formatOffset(this.targets[i15])).append(", ");
        }
        sb5.append('}');
        this.appendAttributes(sb5);
        return sb5.toString();
    }
}

