/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.dex.nodes.RootNode;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class PackageInfo {
    @Nullable
    private final PackageInfo parentPkg;
    private final String fullName;
    private final String name;

    public static synchronized PackageInfo fromFullPkg(RootNode root, String fullPkg) {
        PackageInfo newPkg;
        PackageInfo existPkg = root.getInfoStorage().getPkg(fullPkg);
        if (existPkg != null) {
            return existPkg;
        }
        int lastDot = fullPkg.lastIndexOf(46);
        if (lastDot == -1) {
            newPkg = new PackageInfo(fullPkg, null, fullPkg);
        } else {
            PackageInfo parentPkg = PackageInfo.fromFullPkg(root, fullPkg.substring(0, lastDot));
            newPkg = new PackageInfo(fullPkg, parentPkg, fullPkg.substring(lastDot + 1));
        }
        root.getInfoStorage().putPkg(newPkg);
        return newPkg;
    }

    public static synchronized PackageInfo fromShortName(RootNode root, @Nullable PackageInfo parent, String shortName) {
        String fullPkg = parent == null ? shortName : parent.getFullName() + "." + shortName;
        PackageInfo existPkg = root.getInfoStorage().getPkg(fullPkg);
        if (existPkg != null) {
            return existPkg;
        }
        PackageInfo newPkg = new PackageInfo(fullPkg, parent, shortName);
        root.getInfoStorage().putPkg(newPkg);
        return newPkg;
    }

    private PackageInfo(String fullName, @Nullable PackageInfo parentPkg, String name) {
        this.fullName = fullName;
        this.parentPkg = parentPkg;
        this.name = name;
    }

    public boolean isRoot() {
        return this.parentPkg == null;
    }

    public boolean isDefaultPkg() {
        return this.fullName.isEmpty();
    }

    public String getFullName() {
        return this.fullName;
    }

    @Nullable
    public PackageInfo getParentPkg() {
        return this.parentPkg;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof PackageInfo)) {
            return false;
        }
        return Objects.equals(this.fullName, ((PackageInfo)o15).getFullName());
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public String toString() {
        return this.fullName;
    }
}

