/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.core.utils.Utils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JadxError
implements Comparable<JadxError> {
    private final String error;
    private final Throwable cause;

    public JadxError(String error, Throwable cause) {
        this.error = Objects.requireNonNull(error);
        this.cause = cause;
    }

    public String getError() {
        return this.error;
    }

    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public int compareTo(@NotNull JadxError o15) {
        return this.error.compareTo(o15.getError());
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        JadxError other = (JadxError)o15;
        return this.error.equals(other.error);
    }

    public int hashCode() {
        return this.error.hashCode();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("JadxError: ").append(this.error).append(' ');
        if (this.cause != null) {
            str.append(this.cause.getClass());
            str.append(':');
            str.append(this.cause.getMessage());
            str.append('\n');
            str.append(Utils.getStackTrace(this.cause));
        }
        return str.toString();
    }
}

