/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import jadx.cli.config.IJadxConfig;
import jadx.cli.config.JadxConfigExclude;
import jadx.commons.app.JadxCommonFiles;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.exceptions.JadxArgsValidateException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class JadxConfigAdapter<T extends IJadxConfig> {
    private static final ExclusionStrategy GSON_EXCLUSION_STRATEGY = new ExclusionStrategy(){

        @Override
        public boolean shouldSkipField(FieldAttributes f15) {
            return f15.getAnnotation(JadxConfigExclude.class) != null;
        }

        @Override
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };
    private final Class<T> configCls;
    private final String defaultConfigFileName;
    private final Gson gson;
    private Path configPath;

    public JadxConfigAdapter(Class<T> configCls, String defaultConfigName) {
        this(configCls, defaultConfigName, gsonBuilder -> {});
    }

    public JadxConfigAdapter(Class<T> configCls, String defaultConfigName, Consumer<GsonBuilder> applyGsonOptions) {
        this.configCls = configCls;
        this.defaultConfigFileName = defaultConfigName + ".json";
        GsonBuilder gsonBuilder = GsonUtils.defaultGsonBuilder();
        gsonBuilder.setExclusionStrategies(GSON_EXCLUSION_STRATEGY);
        applyGsonOptions.accept(gsonBuilder);
        this.gson = gsonBuilder.create();
    }

    public void useConfigRef(String configRef) {
        this.configPath = this.resolveConfigRef(configRef);
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public String getDefaultConfigFileName() {
        return this.defaultConfigFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public T load() {
        if (!Files.isRegularFile(this.configPath, new LinkOption[0])) {
            return null;
        }
        try (JsonReader reader = this.gson.newJsonReader(Files.newBufferedReader(this.configPath));){
            IJadxConfig iJadxConfig = (IJadxConfig)this.gson.fromJson(reader, this.configCls);
            return (T)iJadxConfig;
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Failed to load config file: " + String.valueOf(this.configPath), e15);
        }
    }

    public void save(T configObject) {
        try {
            String jsonStr = this.gson.toJson(configObject, this.configCls);
            Files.writeString(this.configPath, (CharSequence)jsonStr, new OpenOption[0]);
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Failed to save config file: " + String.valueOf(this.configPath), e15);
        }
    }

    public String objectToJsonString(T configObject) {
        return this.gson.toJson(configObject, this.configCls);
    }

    public T jsonStringToObject(String jsonStr) {
        return (T)((IJadxConfig)this.gson.fromJson(jsonStr, this.configCls));
    }

    private Path resolveConfigRef(String configRef) {
        if (configRef == null || configRef.isEmpty()) {
            return JadxCommonFiles.getConfigDir().resolve(this.defaultConfigFileName);
        }
        if (configRef.contains("/") || configRef.contains("\\")) {
            if (!configRef.toLowerCase().endsWith(".json")) {
                throw new JadxArgsValidateException("Config file extension should be '.json'");
            }
            return Path.of(configRef, new String[0]);
        }
        return JadxCommonFiles.getConfigDir().resolve(configRef + ".json");
    }
}

