/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.utils;

import jadx.core.utils.Utils;
import jadx.zip.IZipEntry;
import jadx.zip.ZipReader;
import jadx.zip.io.LimitedInputStream;
import jadx.zip.security.DisabledZipSecurity;
import jadx.zip.security.IJadxZipSecurity;
import jadx.zip.security.JadxZipSecurity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ZipSecurity {
    private static final boolean DISABLE_CHECKS = Utils.getEnvVarBool("JADX_DISABLE_ZIP_SECURITY", false);
    private static final int MAX_ENTRIES_COUNT = Utils.getEnvVarInt("JADX_ZIP_MAX_ENTRIES_COUNT", 100000);
    private static final IJadxZipSecurity ZIP_SECURITY = ZipSecurity.buildZipSecurity();
    private static final ZipReader ZIP_READER = new ZipReader(ZIP_SECURITY);

    private static IJadxZipSecurity buildZipSecurity() {
        if (DISABLE_CHECKS) {
            return DisabledZipSecurity.INSTANCE;
        }
        JadxZipSecurity jadxZipSecurity = new JadxZipSecurity();
        jadxZipSecurity.setMaxEntriesCount(MAX_ENTRIES_COUNT);
        return jadxZipSecurity;
    }

    private ZipSecurity() {
    }

    public static boolean isInSubDirectory(File baseDir, File file2) {
        return ZIP_SECURITY.isInSubDirectory(baseDir, file2);
    }

    public static boolean isValidZipEntryName(String entryName) {
        return ZIP_SECURITY.isValidEntryName(entryName);
    }

    public static boolean isZipBomb(IZipEntry entry) {
        return !ZIP_SECURITY.isValidEntry(entry);
    }

    public static boolean isValidZipEntry(IZipEntry entry) {
        return ZIP_SECURITY.isValidEntry(entry);
    }

    public static InputStream getInputStreamForEntry(ZipFile zipFile, ZipEntry entry) throws IOException {
        if (DISABLE_CHECKS) {
            return new BufferedInputStream(zipFile.getInputStream(entry));
        }
        InputStream in4 = zipFile.getInputStream(entry);
        LimitedInputStream limited = new LimitedInputStream(in4, entry.getSize());
        return new BufferedInputStream(limited);
    }

    @Nullable
    public static <R> R visitZipEntries(File file2, Function<IZipEntry, R> visitor2) {
        return ZIP_READER.visitEntries(file2, visitor2);
    }

    public static void readZipEntries(File file2, BiConsumer<IZipEntry, InputStream> visitor2) {
        ZIP_READER.readEntries(file2, visitor2);
    }
}

