/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastSubject<T>
extends Subject<T> {
    final SpscLinkedArrayQueue<T> queue;
    final AtomicReference<Observer<? super T>> downstream;
    final AtomicReference<Runnable> onTerminate;
    final boolean delayError;
    volatile boolean disposed;
    volatile boolean done;
    Throwable error;
    final AtomicBoolean once;
    final BasicIntQueueDisposable<T> wip;
    boolean enableOperatorFusion;

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create() {
        return new UnicastSubject<T>(UnicastSubject.bufferSize(), null, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new UnicastSubject<T>(capacityHint, null, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(int capacityHint, @NonNull Runnable onTerminate) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        Objects.requireNonNull(onTerminate, "onTerminate");
        return new UnicastSubject<T>(capacityHint, onTerminate, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(int capacityHint, @NonNull Runnable onTerminate, boolean delayError) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        Objects.requireNonNull(onTerminate, "onTerminate");
        return new UnicastSubject<T>(capacityHint, onTerminate, delayError);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(boolean delayError) {
        return new UnicastSubject<T>(UnicastSubject.bufferSize(), null, delayError);
    }

    UnicastSubject(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(capacityHint);
        this.onTerminate = new AtomicReference<Runnable>(onTerminate);
        this.delayError = delayError;
        this.downstream = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastQueueDisposable();
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            observer.onSubscribe(this.wip);
            this.downstream.lazySet(observer);
            if (this.disposed) {
                this.downstream.lazySet(null);
                return;
            }
            this.drain();
        } else {
            EmptyDisposable.error((Throwable)new IllegalStateException("Only a single observer allowed."), observer);
        }
    }

    void doTerminate() {
        Runnable r15 = this.onTerminate.get();
        if (r15 != null && this.onTerminate.compareAndSet(r15, null)) {
            r15.run();
        }
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (this.done || this.disposed) {
            d15.dispose();
        }
    }

    @Override
    public void onNext(T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.done || this.disposed) {
            return;
        }
        this.queue.offer(t15);
        this.drain();
    }

    @Override
    public void onError(Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.done || this.disposed) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.error = t15;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.disposed) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    void drainNormal(Observer<? super T> a15) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q15 = this.queue;
        boolean failFast = !this.delayError;
        boolean canBeError = true;
        while (true) {
            boolean empty;
            if (this.disposed) {
                this.downstream.lazySet(null);
                q15.clear();
                return;
            }
            boolean d15 = this.done;
            T v15 = this.queue.poll();
            boolean bl4 = empty = v15 == null;
            if (d15) {
                if (failFast && canBeError) {
                    if (this.failedFast(q15, a15)) {
                        return;
                    }
                    canBeError = false;
                }
                if (empty) {
                    this.errorOrComplete(a15);
                    return;
                }
            }
            if (!empty) {
                a15.onNext(v15);
                continue;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    void drainFused(Observer<? super T> a15) {
        boolean failFast;
        int missed = 1;
        SpscLinkedArrayQueue<T> q15 = this.queue;
        boolean bl4 = failFast = !this.delayError;
        do {
            if (this.disposed) {
                this.downstream.lazySet(null);
                return;
            }
            boolean d15 = this.done;
            if (failFast && d15 && this.failedFast(q15, a15)) {
                return;
            }
            a15.onNext(null);
            if (!d15) continue;
            this.errorOrComplete(a15);
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void errorOrComplete(Observer<? super T> a15) {
        this.downstream.lazySet(null);
        Throwable ex4 = this.error;
        if (ex4 != null) {
            a15.onError(ex4);
        } else {
            a15.onComplete();
        }
    }

    boolean failedFast(SimpleQueue<T> q15, Observer<? super T> a15) {
        Throwable ex4 = this.error;
        if (ex4 != null) {
            this.downstream.lazySet(null);
            q15.clear();
            a15.onError(ex4);
            return true;
        }
        return false;
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        Observer<? super T> a15 = this.downstream.get();
        int missed = 1;
        while (true) {
            if (a15 != null) {
                if (this.enableOperatorFusion) {
                    this.drainFused(a15);
                } else {
                    this.drainNormal(a15);
                }
                return;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            a15 = this.downstream.get();
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasObservers() {
        return this.downstream.get() != null;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    final class UnicastQueueDisposable
    extends BasicIntQueueDisposable<T> {
        private static final long serialVersionUID = 7926949470189395511L;

        UnicastQueueDisposable() {
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                UnicastSubject.this.enableOperatorFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            return UnicastSubject.this.queue.poll();
        }

        @Override
        public boolean isEmpty() {
            return UnicastSubject.this.queue.isEmpty();
        }

        @Override
        public void clear() {
            UnicastSubject.this.queue.clear();
        }

        @Override
        public void dispose() {
            if (!UnicastSubject.this.disposed) {
                UnicastSubject.this.disposed = true;
                UnicastSubject.this.doTerminate();
                UnicastSubject.this.downstream.lazySet(null);
                if (UnicastSubject.this.wip.getAndIncrement() == 0) {
                    UnicastSubject.this.downstream.lazySet(null);
                    if (!UnicastSubject.this.enableOperatorFusion) {
                        UnicastSubject.this.queue.clear();
                    }
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return UnicastSubject.this.disposed;
        }
    }
}

