/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.Serializable;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public enum NotificationLite {
    COMPLETE;


    public static <T> Object next(T value) {
        return value;
    }

    public static Object complete() {
        return COMPLETE;
    }

    public static Object error(Throwable e15) {
        return new ErrorNotification(e15);
    }

    public static Object subscription(Subscription s15) {
        return new SubscriptionNotification(s15);
    }

    public static Object disposable(Disposable d15) {
        return new DisposableNotification(d15);
    }

    public static boolean isComplete(Object o15) {
        return o15 == COMPLETE;
    }

    public static boolean isError(Object o15) {
        return o15 instanceof ErrorNotification;
    }

    public static boolean isSubscription(Object o15) {
        return o15 instanceof SubscriptionNotification;
    }

    public static boolean isDisposable(Object o15) {
        return o15 instanceof DisposableNotification;
    }

    public static <T> T getValue(Object o15) {
        return (T)o15;
    }

    public static Throwable getError(Object o15) {
        return ((ErrorNotification)o15).e;
    }

    public static Subscription getSubscription(Object o15) {
        return ((SubscriptionNotification)o15).upstream;
    }

    public static Disposable getDisposable(Object o15) {
        return ((DisposableNotification)o15).upstream;
    }

    public static <T> boolean accept(Object o15, Subscriber<? super T> s15) {
        if (o15 == COMPLETE) {
            s15.onComplete();
            return true;
        }
        if (o15 instanceof ErrorNotification) {
            s15.onError(((ErrorNotification)o15).e);
            return true;
        }
        s15.onNext(o15);
        return false;
    }

    public static <T> boolean accept(Object o15, Observer<? super T> observer) {
        if (o15 == COMPLETE) {
            observer.onComplete();
            return true;
        }
        if (o15 instanceof ErrorNotification) {
            observer.onError(((ErrorNotification)o15).e);
            return true;
        }
        observer.onNext(o15);
        return false;
    }

    public static <T> boolean acceptFull(Object o15, Subscriber<? super T> s15) {
        if (o15 == COMPLETE) {
            s15.onComplete();
            return true;
        }
        if (o15 instanceof ErrorNotification) {
            s15.onError(((ErrorNotification)o15).e);
            return true;
        }
        if (o15 instanceof SubscriptionNotification) {
            s15.onSubscribe(((SubscriptionNotification)o15).upstream);
            return false;
        }
        s15.onNext(o15);
        return false;
    }

    public static <T> boolean acceptFull(Object o15, Observer<? super T> observer) {
        if (o15 == COMPLETE) {
            observer.onComplete();
            return true;
        }
        if (o15 instanceof ErrorNotification) {
            observer.onError(((ErrorNotification)o15).e);
            return true;
        }
        if (o15 instanceof DisposableNotification) {
            observer.onSubscribe(((DisposableNotification)o15).upstream);
            return false;
        }
        observer.onNext(o15);
        return false;
    }

    public String toString() {
        return "NotificationLite.Complete";
    }

    static final class DisposableNotification
    implements Serializable {
        private static final long serialVersionUID = -7482590109178395495L;
        final Disposable upstream;

        DisposableNotification(Disposable d15) {
            this.upstream = d15;
        }

        public String toString() {
            return "NotificationLite.Disposable[" + this.upstream + "]";
        }
    }

    static final class SubscriptionNotification
    implements Serializable {
        private static final long serialVersionUID = -1322257508628817540L;
        final Subscription upstream;

        SubscriptionNotification(Subscription s15) {
            this.upstream = s15;
        }

        public String toString() {
            return "NotificationLite.Subscription[" + this.upstream + "]";
        }
    }

    static final class ErrorNotification
    implements Serializable {
        private static final long serialVersionUID = -8759979445933046293L;
        final Throwable e;

        ErrorNotification(Throwable e15) {
            this.e = e15;
        }

        public String toString() {
            return "NotificationLite.Error[" + this.e + "]";
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ErrorNotification) {
                ErrorNotification n15 = (ErrorNotification)obj;
                return Objects.equals(this.e, n15.e);
            }
            return false;
        }
    }
}

