/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import org.reactivestreams.Subscriber;

public class AppendOnlyLinkedArrayList<T> {
    final int capacity;
    final Object[] head;
    Object[] tail;
    int offset;

    public AppendOnlyLinkedArrayList(int capacity) {
        this.capacity = capacity;
        this.head = new Object[capacity + 1];
        this.tail = this.head;
    }

    public void add(T value) {
        int o15 = this.offset;
        int c15 = this.capacity;
        if (o15 == c15) {
            Object[] next;
            this.tail[c15] = next = new Object[c15 + 1];
            this.tail = next;
            o15 = 0;
        }
        this.tail[o15] = value;
        this.offset = o15 + 1;
    }

    public void setFirst(T value) {
        this.head[0] = value;
    }

    public void forEachWhile(NonThrowingPredicate<? super T> consumer) {
        Object[] a15 = this.head;
        int c15 = this.capacity;
        while (a15 != null) {
            Object o15;
            for (int i15 = 0; i15 < c15 && (o15 = a15[i15]) != null; ++i15) {
                if (!consumer.test(o15)) continue;
                return;
            }
            a15 = (Object[])a15[c15];
        }
    }

    public <U> boolean accept(Subscriber<? super U> subscriber) {
        Object[] a15 = this.head;
        int c15 = this.capacity;
        while (a15 != null) {
            Object o15;
            for (int i15 = 0; i15 < c15 && (o15 = a15[i15]) != null; ++i15) {
                if (!NotificationLite.acceptFull(o15, subscriber)) continue;
                return true;
            }
            a15 = (Object[])a15[c15];
        }
        return false;
    }

    public <U> boolean accept(Observer<? super U> observer) {
        Object[] a15 = this.head;
        int c15 = this.capacity;
        while (a15 != null) {
            Object o15;
            for (int i15 = 0; i15 < c15 && (o15 = a15[i15]) != null; ++i15) {
                if (!NotificationLite.acceptFull(o15, observer)) continue;
                return true;
            }
            a15 = (Object[])a15[c15];
        }
        return false;
    }

    public <S> void forEachWhile(S state, BiPredicate<? super S, ? super T> consumer) throws Throwable {
        Object[] a15 = this.head;
        int c15 = this.capacity;
        while (true) {
            for (int i15 = 0; i15 < c15; ++i15) {
                Object o15 = a15[i15];
                if (o15 == null) {
                    return;
                }
                if (!consumer.test(state, o15)) continue;
                return;
            }
            a15 = (Object[])a15[c15];
        }
    }

    public static interface NonThrowingPredicate<T>
    extends Predicate<T> {
        @Override
        public boolean test(T var1);
    }
}

