/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public final class SchedulerPoolFactory {
    static final String PURGE_ENABLED_KEY = "rx3.purge-enabled";
    public static final boolean PURGE_ENABLED;

    private SchedulerPoolFactory() {
        throw new IllegalStateException("No instances!");
    }

    static boolean getBooleanProperty(boolean enabled, String key, boolean defaultNotFound, boolean defaultNotEnabled, Function<String, String> propertyAccessor) {
        if (enabled) {
            try {
                String value = propertyAccessor.apply(key);
                if (value == null) {
                    return defaultNotFound;
                }
                return "true".equals(value);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                return defaultNotFound;
            }
        }
        return defaultNotEnabled;
    }

    public static ScheduledExecutorService create(ThreadFactory factory) {
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1, factory);
        exec.setRemoveOnCancelPolicy(PURGE_ENABLED);
        return exec;
    }

    static {
        SystemPropertyAccessor propertyAccessor = new SystemPropertyAccessor();
        PURGE_ENABLED = SchedulerPoolFactory.getBooleanProperty(true, PURGE_ENABLED_KEY, true, true, propertyAccessor);
    }

    static final class SystemPropertyAccessor
    implements Function<String, String> {
        SystemPropertyAccessor() {
        }

        @Override
        public String apply(String t15) {
            return System.getProperty(t15);
        }
    }
}

