/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.schedulers.SchedulerRunnableIntrospection;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractDirectTask
extends AtomicReference<Future<?>>
implements Disposable,
SchedulerRunnableIntrospection {
    private static final long serialVersionUID = 1811839108042568751L;
    protected final Runnable runnable;
    protected final boolean interruptOnCancel;
    protected Thread runner;
    protected static final FutureTask<Void> FINISHED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);
    protected static final FutureTask<Void> DISPOSED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);

    AbstractDirectTask(Runnable runnable, boolean interruptOnCancel) {
        this.runnable = runnable;
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public final void dispose() {
        Future f15 = (Future)this.get();
        if (f15 != FINISHED && f15 != DISPOSED && this.compareAndSet(f15, DISPOSED) && f15 != null) {
            this.cancelFuture(f15);
        }
    }

    @Override
    public final boolean isDisposed() {
        Future f15 = (Future)this.get();
        return f15 == FINISHED || f15 == DISPOSED;
    }

    public final void setFuture(Future<?> future) {
        Future f15;
        while ((f15 = (Future)this.get()) != FINISHED) {
            if (f15 == DISPOSED) {
                this.cancelFuture(future);
                break;
            }
            if (!this.compareAndSet(f15, future)) continue;
            break;
        }
    }

    private void cancelFuture(Future<?> future) {
        if (this.runner == Thread.currentThread()) {
            future.cancel(false);
        } else {
            future.cancel(this.interruptOnCancel);
        }
    }

    @Override
    public Runnable getWrappedRunnable() {
        return this.runnable;
    }

    @Override
    public String toString() {
        Thread r15;
        Future f15 = (Future)this.get();
        String status = f15 == FINISHED ? "Finished" : (f15 == DISPOSED ? "Disposed" : ((r15 = this.runner) != null ? "Running on " + this.runner : "Waiting"));
        return this.getClass().getSimpleName() + "[" + status + "]";
    }
}

