/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;

public final class SingleError<T>
extends Single<T> {
    final Supplier<? extends Throwable> errorSupplier;

    public SingleError(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        Throwable error;
        try {
            error = ExceptionHelper.nullCheck(this.errorSupplier.get(), "Supplier returned a null Throwable.");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            error = e15;
        }
        EmptyDisposable.error(error, observer);
    }
}

