/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;

public final class SingleDoOnSuccess<T>
extends Single<T> {
    final SingleSource<T> source;
    final Consumer<? super T> onSuccess;

    public SingleDoOnSuccess(SingleSource<T> source, Consumer<? super T> onSuccess) {
        this.source = source;
        this.onSuccess = onSuccess;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new DoOnSuccess(observer));
    }

    final class DoOnSuccess
    implements SingleObserver<T> {
        final SingleObserver<? super T> downstream;

        DoOnSuccess(SingleObserver<? super T> observer) {
            this.downstream = observer;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.downstream.onSubscribe(d15);
        }

        @Override
        public void onSuccess(T value) {
            try {
                SingleDoOnSuccess.this.onSuccess.accept(value);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(ex4);
                return;
            }
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e15) {
            this.downstream.onError(e15);
        }
    }
}

