/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableZip<T, R>
extends Observable<R> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public ObservableZip(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super R> observer) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new ObservableSource[8];
            for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                if (count == sources.length) {
                    ObservableSource[] b15 = new ObservableSource[count + (count >> 2)];
                    System.arraycopy(sources, 0, b15, 0, count);
                    sources = b15;
                }
                sources[count++] = observableSource;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        ZipCoordinator<? extends T, R> zc5 = new ZipCoordinator<T, R>(observer, this.zipper, count, this.delayError);
        zc5.subscribe(sources, this.bufferSize);
    }

    static final class ZipObserver<T, R>
    implements Observer<T> {
        final ZipCoordinator<T, R> parent;
        final SpscLinkedArrayQueue<T> queue;
        volatile boolean done;
        Throwable error;
        final AtomicReference<Disposable> upstream = new AtomicReference();

        ZipObserver(ZipCoordinator<T, R> parent, int bufferSize) {
            this.parent = parent;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this.upstream, d15);
        }

        @Override
        public void onNext(T t15) {
            this.queue.offer(t15);
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void dispose() {
            DisposableHelper.dispose(this.upstream);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 2983708048395377667L;
        final Observer<? super R> downstream;
        final Function<? super Object[], ? extends R> zipper;
        final ZipObserver<T, R>[] observers;
        final T[] row;
        final boolean delayError;
        volatile boolean cancelled;

        ZipCoordinator(Observer<? super R> actual, Function<? super Object[], ? extends R> zipper, int count, boolean delayError) {
            this.downstream = actual;
            this.zipper = zipper;
            this.observers = new ZipObserver[count];
            this.row = new Object[count];
            this.delayError = delayError;
        }

        public void subscribe(ObservableSource<? extends T>[] sources, int bufferSize) {
            int i15;
            ZipObserver<T, R>[] s15 = this.observers;
            int len = s15.length;
            for (i15 = 0; i15 < len; ++i15) {
                s15[i15] = new ZipObserver(this, bufferSize);
            }
            this.lazySet(0);
            this.downstream.onSubscribe(this);
            for (i15 = 0; i15 < len; ++i15) {
                if (this.cancelled) {
                    return;
                }
                sources[i15].subscribe(s15[i15]);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelSources();
                if (this.getAndIncrement() == 0) {
                    this.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancel() {
            this.clear();
            this.cancelSources();
        }

        void cancelSources() {
            for (ZipObserver<T, R> zs4 : this.observers) {
                zs4.dispose();
            }
        }

        void clear() {
            for (ZipObserver<T, R> zs4 : this.observers) {
                zs4.queue.clear();
            }
        }

        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missing = 1;
            ZipObserver<T, R>[] zs4 = this.observers;
            Observer<R> a15 = this.downstream;
            Object[] os4 = this.row;
            boolean delayError = this.delayError;
            while (true) {
                int i15 = 0;
                int emptyCount = 0;
                for (ZipObserver<T, R> z15 : zs4) {
                    Throwable ex4;
                    if (os4[i15] == null) {
                        boolean empty;
                        boolean d15 = z15.done;
                        Object v15 = z15.queue.poll();
                        boolean bl4 = empty = v15 == null;
                        if (this.checkTerminated(d15, empty, a15, delayError, z15)) {
                            return;
                        }
                        if (!empty) {
                            os4[i15] = v15;
                        } else {
                            ++emptyCount;
                        }
                    } else if (z15.done && !delayError && (ex4 = z15.error) != null) {
                        this.cancelled = true;
                        this.cancel();
                        a15.onError(ex4);
                        return;
                    }
                    ++i15;
                }
                if (emptyCount == 0) {
                    R v16;
                    try {
                        v16 = Objects.requireNonNull(this.zipper.apply((Object[])os4.clone()), "The zipper returned a null value");
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        this.cancel();
                        a15.onError(ex5);
                        return;
                    }
                    a15.onNext(v16);
                    Arrays.fill(os4, null);
                    continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d15, boolean empty, Observer<? super R> a15, boolean delayError, ZipObserver<?, ?> source) {
            if (this.cancelled) {
                this.cancel();
                return true;
            }
            if (d15) {
                if (delayError) {
                    if (empty) {
                        Throwable e15 = source.error;
                        this.cancelled = true;
                        this.cancel();
                        if (e15 != null) {
                            a15.onError(e15);
                        } else {
                            a15.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e16 = source.error;
                    if (e16 != null) {
                        this.cancelled = true;
                        this.cancel();
                        a15.onError(e16);
                        return true;
                    }
                    if (empty) {
                        this.cancelled = true;
                        this.cancel();
                        a15.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

