/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWindowSubscribeIntercept;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.observers.DisposableObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowBoundary<T, B>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final ObservableSource<B> other;
    final int capacityHint;

    public ObservableWindowBoundary(ObservableSource<T> source, ObservableSource<B> other, int capacityHint) {
        super(source);
        this.other = other;
        this.capacityHint = capacityHint;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> observer) {
        WindowBoundaryMainObserver parent = new WindowBoundaryMainObserver(observer, this.capacityHint);
        observer.onSubscribe(parent);
        this.other.subscribe(parent.boundaryObserver);
        this.source.subscribe(parent);
    }

    static final class WindowBoundaryInnerObserver<T, B>
    extends DisposableObserver<B> {
        final WindowBoundaryMainObserver<T, B> parent;
        boolean done;

        WindowBoundaryInnerObserver(WindowBoundaryMainObserver<T, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t15) {
            if (this.done) {
                return;
            }
            this.parent.innerNext();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.innerComplete();
        }
    }

    static final class WindowBoundaryMainObserver<T, B>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 2233020065421370272L;
        final Observer<? super Observable<T>> downstream;
        final int capacityHint;
        final WindowBoundaryInnerObserver<T, B> boundaryObserver;
        final AtomicReference<Disposable> upstream;
        final AtomicInteger windows;
        final MpscLinkedQueue<Object> queue;
        final AtomicThrowable errors;
        final AtomicBoolean stopWindows;
        static final Object NEXT_WINDOW = new Object();
        volatile boolean done;
        UnicastSubject<T> window;

        WindowBoundaryMainObserver(Observer<? super Observable<T>> downstream, int capacityHint) {
            this.downstream = downstream;
            this.capacityHint = capacityHint;
            this.boundaryObserver = new WindowBoundaryInnerObserver(this);
            this.upstream = new AtomicReference();
            this.windows = new AtomicInteger(1);
            this.queue = new MpscLinkedQueue();
            this.errors = new AtomicThrowable();
            this.stopWindows = new AtomicBoolean();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.setOnce(this.upstream, d15)) {
                this.innerNext();
            }
        }

        @Override
        public void onNext(T t15) {
            this.queue.offer(t15);
            this.drain();
        }

        @Override
        public void onError(Throwable e15) {
            this.boundaryObserver.dispose();
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.boundaryObserver.dispose();
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (this.stopWindows.compareAndSet(false, true)) {
                this.boundaryObserver.dispose();
                if (this.windows.decrementAndGet() == 0) {
                    DisposableHelper.dispose(this.upstream);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.stopWindows.get();
        }

        @Override
        public void run() {
            if (this.windows.decrementAndGet() == 0) {
                DisposableHelper.dispose(this.upstream);
            }
        }

        void innerNext() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        void innerError(Throwable e15) {
            DisposableHelper.dispose(this.upstream);
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.done = true;
                this.drain();
            }
        }

        void innerComplete() {
            DisposableHelper.dispose(this.upstream);
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<Observable<ObservableWindowSubscribeIntercept<T>>> downstream = this.downstream;
            MpscLinkedQueue<Object> queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                boolean empty;
                if (this.windows.get() == 0) {
                    queue.clear();
                    this.window = null;
                    return;
                }
                UnicastSubject<Object> w15 = this.window;
                boolean d15 = this.done;
                if (d15 && errors.get() != null) {
                    queue.clear();
                    Throwable ex4 = errors.terminate();
                    if (w15 != null) {
                        this.window = null;
                        w15.onError(ex4);
                    }
                    downstream.onError(ex4);
                    return;
                }
                Object v15 = queue.poll();
                boolean bl4 = empty = v15 == null;
                if (d15 && empty) {
                    Throwable ex5 = errors.terminate();
                    if (ex5 == null) {
                        if (w15 != null) {
                            this.window = null;
                            w15.onComplete();
                        }
                        downstream.onComplete();
                    } else {
                        if (w15 != null) {
                            this.window = null;
                            w15.onError(ex5);
                        }
                        downstream.onError(ex5);
                    }
                    return;
                }
                if (!empty) {
                    if (v15 != NEXT_WINDOW) {
                        w15.onNext(v15);
                        continue;
                    }
                    if (w15 != null) {
                        this.window = null;
                        w15.onComplete();
                    }
                    if (this.stopWindows.get()) continue;
                    w15 = UnicastSubject.create(this.capacityHint, this);
                    this.window = w15;
                    this.windows.getAndIncrement();
                    ObservableWindowSubscribeIntercept<T> intercept = new ObservableWindowSubscribeIntercept<T>(w15);
                    downstream.onNext(intercept);
                    if (!intercept.tryAbandon()) continue;
                    w15.onComplete();
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

