/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableTakeLastTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public ObservableTakeLastTimed(ObservableSource<T> source, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new TakeLastTimedObserver<T>(t15, this.count, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class TakeLastTimedObserver<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5677354903406201275L;
        final Observer<? super T> downstream;
        final long count;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Disposable upstream;
        volatile boolean cancelled;
        Throwable error;

        TakeLastTimedObserver(Observer<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.count = count;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            long ts4;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            long now = this.scheduler.now(this.unit);
            long time = this.time;
            long c15 = this.count;
            boolean unbounded = c15 == Long.MAX_VALUE;
            q15.offer(now, t15);
            while (!q15.isEmpty() && ((ts4 = ((Long)q15.peek()).longValue()) <= now - time || !unbounded && (long)(q15.size() >> 1) > c15)) {
                q15.poll();
                q15.poll();
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                if (this.compareAndSet(false, true)) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (!this.compareAndSet(false, true)) {
                return;
            }
            Observer<Object> a15 = this.downstream;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            boolean delayError = this.delayError;
            long timestampLimit = this.scheduler.now(this.unit) - this.time;
            while (true) {
                boolean empty;
                Throwable ex4;
                if (this.cancelled) {
                    q15.clear();
                    return;
                }
                if (!delayError && (ex4 = this.error) != null) {
                    q15.clear();
                    a15.onError(ex4);
                    return;
                }
                Object ts4 = q15.poll();
                boolean bl4 = empty = ts4 == null;
                if (empty) {
                    Throwable ex5 = this.error;
                    if (ex5 != null) {
                        a15.onError(ex5);
                    } else {
                        a15.onComplete();
                    }
                    return;
                }
                Object o15 = q15.poll();
                if ((Long)ts4 < timestampLimit) continue;
                a15.onNext(o15);
            }
        }
    }
}

