/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.observables.ConnectableObservable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableRefCount<T>
extends Observable<T> {
    final ConnectableObservable<T> source;
    final int n;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    RefConnection connection;

    public ObservableRefCount(ConnectableObservable<T> source) {
        this(source, 1, 0L, TimeUnit.NANOSECONDS, null);
    }

    public ObservableRefCount(ConnectableObservable<T> source, int n15, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.n = n15;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        RefConnection conn;
        boolean connect = false;
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            long c15;
            conn = this.connection;
            if (conn == null) {
                this.connection = conn = new RefConnection(this);
            }
            if ((c15 = conn.subscriberCount) == 0L && conn.timer != null) {
                conn.timer.dispose();
            }
            conn.subscriberCount = c15 + 1L;
            if (!conn.connected && c15 + 1L == (long)this.n) {
                connect = true;
                conn.connected = true;
            }
        }
        this.source.subscribe(new RefCountObserver<T>(observer, this, conn));
        if (connect) {
            this.source.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefConnection rc5) {
        SequentialDisposable sd5;
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            long c15;
            if (this.connection == null || this.connection != rc5) {
                return;
            }
            rc5.subscriberCount = c15 = rc5.subscriberCount - 1L;
            if (c15 != 0L || !rc5.connected) {
                return;
            }
            if (this.timeout == 0L) {
                this.timeout(rc5);
                return;
            }
            sd5 = new SequentialDisposable();
            rc5.timer = sd5;
        }
        sd5.replace(this.scheduler.scheduleDirect(rc5, this.timeout, this.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefConnection rc5) {
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            if (this.connection == rc5) {
                if (rc5.timer != null) {
                    rc5.timer.dispose();
                    rc5.timer = null;
                }
                if (--rc5.subscriberCount == 0L) {
                    this.connection = null;
                    this.source.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(RefConnection rc5) {
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            if (rc5.subscriberCount == 0L && rc5 == this.connection) {
                this.connection = null;
                Disposable connectionObject = (Disposable)rc5.get();
                DisposableHelper.dispose(rc5);
                if (connectionObject == null) {
                    rc5.disconnectedEarly = true;
                } else {
                    this.source.reset();
                }
            }
        }
    }

    static final class RefCountObserver<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -7419642935409022375L;
        final Observer<? super T> downstream;
        final ObservableRefCount<T> parent;
        final RefConnection connection;
        Disposable upstream;

        RefCountObserver(Observer<? super T> downstream, ObservableRefCount<T> parent, RefConnection connection) {
            this.downstream = downstream;
            this.parent = parent;
            this.connection = connection;
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onError(t15);
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            if (this.compareAndSet(false, true)) {
                this.parent.cancel(this.connection);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }
    }

    static final class RefConnection
    extends AtomicReference<Disposable>
    implements Runnable,
    Consumer<Disposable> {
        private static final long serialVersionUID = -4552101107598366241L;
        final ObservableRefCount<?> parent;
        Disposable timer;
        long subscriberCount;
        boolean connected;
        boolean disconnectedEarly;

        RefConnection(ObservableRefCount<?> parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.timeout(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Disposable t15) {
            DisposableHelper.replace(this, t15);
            ObservableRefCount<?> observableRefCount = this.parent;
            synchronized (observableRefCount) {
                if (this.disconnectedEarly) {
                    this.parent.source.reset();
                }
            }
        }
    }
}

