/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.fuseable.CancellableQueueFuseable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableFromRunnable<T>
extends Observable<T>
implements Supplier<T> {
    final Runnable run;

    public ObservableFromRunnable(Runnable run) {
        this.run = run;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        CancellableQueueFuseable qs4 = new CancellableQueueFuseable();
        observer.onSubscribe(qs4);
        if (!qs4.isDisposed()) {
            try {
                this.run.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                if (!qs4.isDisposed()) {
                    observer.onError(ex4);
                } else {
                    RxJavaPlugins.onError(ex4);
                }
                return;
            }
            if (!qs4.isDisposed()) {
                observer.onComplete();
            }
        }
    }

    @Override
    public T get() throws Throwable {
        this.run.run();
        return null;
    }
}

