/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.observers.DisposableObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

public final class BlockingObservableLatest<T>
implements Iterable<T> {
    final ObservableSource<T> source;

    public BlockingObservableLatest(ObservableSource<T> source) {
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        BlockingObservableLatestIterator lio = new BlockingObservableLatestIterator();
        Observable materialized = Observable.wrap(this.source).materialize();
        materialized.subscribe(lio);
        return lio;
    }

    static final class BlockingObservableLatestIterator<T>
    extends DisposableObserver<Notification<T>>
    implements Iterator<T> {
        Notification<T> iteratorNotification;
        final Semaphore notify = new Semaphore(0);
        final AtomicReference<Notification<T>> value = new AtomicReference();

        BlockingObservableLatestIterator() {
        }

        @Override
        public void onNext(Notification<T> args) {
            boolean wasNotAvailable;
            boolean bl4 = wasNotAvailable = this.value.getAndSet(args) == null;
            if (wasNotAvailable) {
                this.notify.release();
            }
        }

        @Override
        public void onError(Throwable e15) {
            RxJavaPlugins.onError(e15);
        }

        @Override
        public void onComplete() {
        }

        @Override
        public boolean hasNext() {
            if (this.iteratorNotification != null && this.iteratorNotification.isOnError()) {
                throw ExceptionHelper.wrapOrThrow(this.iteratorNotification.getError());
            }
            if (this.iteratorNotification == null) {
                Notification n15;
                try {
                    BlockingHelper.verifyNonBlocking();
                    this.notify.acquire();
                }
                catch (InterruptedException ex4) {
                    this.dispose();
                    this.iteratorNotification = Notification.createOnError(ex4);
                    throw ExceptionHelper.wrapOrThrow(ex4);
                }
                this.iteratorNotification = n15 = (Notification)this.value.getAndSet(null);
                if (n15.isOnError()) {
                    throw ExceptionHelper.wrapOrThrow(n15.getError());
                }
            }
            return this.iteratorNotification.isOnNext();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T v15 = this.iteratorNotification.getValue();
                this.iteratorNotification = null;
                return v15;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

