/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.AbstractMaybeWithUpstream;
import java.util.Objects;

public final class MaybeOnErrorReturn<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Function<? super Throwable, ? extends T> itemSupplier;

    public MaybeOnErrorReturn(MaybeSource<T> source, Function<? super Throwable, ? extends T> itemSupplier) {
        super(source);
        this.itemSupplier = itemSupplier;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new OnErrorReturnMaybeObserver<T>(observer, this.itemSupplier));
    }

    static final class OnErrorReturnMaybeObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final Function<? super Throwable, ? extends T> itemSupplier;
        Disposable upstream;

        OnErrorReturnMaybeObserver(MaybeObserver<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
            this.downstream = actual;
            this.itemSupplier = valueSupplier;
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e15) {
            T v15;
            try {
                v15 = Objects.requireNonNull(this.itemSupplier.apply(e15), "The itemSupplier returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(new CompositeException(e15, ex4));
                return;
            }
            this.downstream.onSuccess(v15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

