/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;

public final class MaybeErrorCallable<T>
extends Maybe<T> {
    final Supplier<? extends Throwable> errorSupplier;

    public MaybeErrorCallable(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Throwable ex4;
        observer.onSubscribe(Disposable.disposed());
        try {
            ex4 = ExceptionHelper.nullCheck(this.errorSupplier.get(), "Supplier returned a null Throwable.");
        }
        catch (Throwable ex12) {
            Exceptions.throwIfFatal(ex12);
            ex4 = ex12;
        }
        observer.onError(ex4);
    }
}

