/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableUsing<T, D>
extends Flowable<T> {
    final Supplier<? extends D> resourceSupplier;
    final Function<? super D, ? extends Publisher<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public FlowableUsing(Supplier<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        Publisher<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptySubscription.error(e15, s15);
            return;
        }
        try {
            source = Objects.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null Publisher");
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptySubscription.error(new CompositeException(e16, ex4), s15);
                return;
            }
            EmptySubscription.error(e16, s15);
            return;
        }
        UsingSubscriber<? super T, ? super D> us4 = new UsingSubscriber<T, D>(s15, resource, this.disposer, this.eager);
        source.subscribe(us4);
    }

    static final class UsingSubscriber<T, D>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 5904473792286235046L;
        final Subscriber<? super T> downstream;
        final D resource;
        final Consumer<? super D> disposer;
        final boolean eager;
        Subscription upstream;

        UsingSubscriber(Subscriber<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
            this.downstream = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.eager) {
                Throwable innerError = null;
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e15) {
                        Exceptions.throwIfFatal(e15);
                        innerError = e15;
                    }
                }
                if (innerError != null) {
                    this.downstream.onError(new CompositeException(t15, innerError));
                } else {
                    this.downstream.onError(t15);
                }
            } else {
                this.downstream.onError(t15);
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e15) {
                        Exceptions.throwIfFatal(e15);
                        this.downstream.onError(e15);
                        return;
                    }
                }
                this.downstream.onComplete();
            } else {
                this.downstream.onComplete();
                this.disposeResource();
            }
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELLED;
            } else {
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELLED;
                this.disposeResource();
            }
        }

        void disposeResource() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    RxJavaPlugins.onError(e15);
                }
            }
        }
    }
}

