/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTakeWhile<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public FlowableTakeWhile(Flowable<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new TakeWhileSubscriber<T>(s15, this.predicate));
    }

    static final class TakeWhileSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final Predicate<? super T> predicate;
        Subscription upstream;
        boolean done;

        TakeWhileSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate) {
            this.downstream = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            boolean b15;
            if (this.done) {
                return;
            }
            try {
                b15 = this.predicate.test(t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.upstream.cancel();
                this.onError(e15);
                return;
            }
            if (!b15) {
                this.done = true;
                this.upstream.cancel();
                this.downstream.onComplete();
                return;
            }
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

