/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSubscribeOn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean nonScheduledRequests;

    public FlowableSubscribeOn(Flowable<T> source, Scheduler scheduler, boolean nonScheduledRequests) {
        super(source);
        this.scheduler = scheduler;
        this.nonScheduledRequests = nonScheduledRequests;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        Scheduler.Worker w15 = this.scheduler.createWorker();
        SubscribeOnSubscriber<? super T> sos = new SubscribeOnSubscriber<T>(s15, w15, this.source, this.nonScheduledRequests);
        s15.onSubscribe(sos);
        w15.schedule(sos);
    }

    static final class SubscribeOnSubscriber<T>
    extends AtomicReference<Thread>
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 8094547886072529208L;
        final Subscriber<? super T> downstream;
        final Scheduler.Worker worker;
        final AtomicReference<Subscription> upstream;
        final AtomicLong requested;
        final boolean nonScheduledRequests;
        Publisher<T> source;

        SubscribeOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker, Publisher<T> source, boolean requestOn) {
            this.downstream = actual;
            this.worker = worker;
            this.source = source;
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
            this.nonScheduledRequests = !requestOn;
        }

        @Override
        public void run() {
            this.lazySet(Thread.currentThread());
            Publisher<T> src = this.source;
            this.source = null;
            src.subscribe(this);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            long r15;
            if (SubscriptionHelper.setOnce(this.upstream, s15) && (r15 = this.requested.getAndSet(0L)) != 0L) {
                this.requestUpstream(r15, s15);
            }
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                Subscription s15 = this.upstream.get();
                if (s15 != null) {
                    this.requestUpstream(n15, s15);
                } else {
                    long r15;
                    BackpressureHelper.add(this.requested, n15);
                    s15 = this.upstream.get();
                    if (s15 != null && (r15 = this.requested.getAndSet(0L)) != 0L) {
                        this.requestUpstream(r15, s15);
                    }
                }
            }
        }

        void requestUpstream(long n15, Subscription s15) {
            if (this.nonScheduledRequests || Thread.currentThread() == this.get()) {
                s15.request(n15);
            } else {
                this.worker.schedule(new Request(s15, n15));
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            this.worker.dispose();
        }

        static final class Request
        implements Runnable {
            final Subscription upstream;
            final long n;

            Request(Subscription s15, long n15) {
                this.upstream = s15;
                this.n = n15;
            }

            @Override
            public void run() {
                this.upstream.request(this.n);
            }
        }
    }
}

