/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class FlowableReduceSeedSingle<T, R>
extends Single<R> {
    final Publisher<T> source;
    final R seed;
    final BiFunction<R, ? super T, R> reducer;

    public FlowableReduceSeedSingle(Publisher<T> source, R seed, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.seed = seed;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        this.source.subscribe(new ReduceSeedObserver<T, R>(observer, this.reducer, this.seed));
    }

    static final class ReduceSeedObserver<T, R>
    implements FlowableSubscriber<T>,
    Disposable {
        final SingleObserver<? super R> downstream;
        final BiFunction<R, ? super T, R> reducer;
        R value;
        Subscription upstream;

        ReduceSeedObserver(SingleObserver<? super R> actual, BiFunction<R, ? super T, R> reducer, R value) {
            this.downstream = actual;
            this.value = value;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T value) {
            R v15 = this.value;
            if (v15 != null) {
                try {
                    this.value = Objects.requireNonNull(this.reducer.apply(v15, value), "The reducer returned a null value");
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.upstream.cancel();
                    this.onError(ex4);
                }
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.value != null) {
                this.value = null;
                this.upstream = SubscriptionHelper.CANCELLED;
                this.downstream.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            R v15 = this.value;
            if (v15 != null) {
                this.value = null;
                this.upstream = SubscriptionHelper.CANCELLED;
                this.downstream.onSuccess(v15);
            }
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream == SubscriptionHelper.CANCELLED;
        }
    }
}

