/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableObserveOn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean delayError;
    final int prefetch;

    public FlowableObserveOn(Flowable<T> source, Scheduler scheduler, boolean delayError, int prefetch) {
        super(source);
        this.scheduler = scheduler;
        this.delayError = delayError;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        if (s15 instanceof ConditionalSubscriber) {
            this.source.subscribe(new ObserveOnConditionalSubscriber((ConditionalSubscriber)s15, worker, this.delayError, this.prefetch));
        } else {
            this.source.subscribe(new ObserveOnSubscriber<T>(s15, worker, this.delayError, this.prefetch));
        }
    }

    static final class ObserveOnConditionalSubscriber<T>
    extends BaseObserveOnSubscriber<T> {
        private static final long serialVersionUID = 644624475404284533L;
        final ConditionalSubscriber<? super T> downstream;
        long consumed;

        ObserveOnConditionalSubscriber(ConditionalSubscriber<? super T> actual, Scheduler.Worker worker, boolean delayError, int prefetch) {
            super(worker, delayError, prefetch);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription f15 = (QueueSubscription)s15;
                    int m15 = f15.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = 1;
                        this.queue = f15;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = 2;
                        this.queue = f15;
                        this.downstream.onSubscribe(this);
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.downstream.onSubscribe(this);
                s15.request(this.prefetch);
            }
        }

        @Override
        void runSync() {
            int missed = 1;
            ConditionalSubscriber a15 = this.downstream;
            SimpleQueue q15 = this.queue;
            long e15 = this.produced;
            do {
                long r15 = this.requested.get();
                while (e15 != r15) {
                    Object v15;
                    try {
                        v15 = q15.poll();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.cancelled = true;
                        this.upstream.cancel();
                        a15.onError(ex4);
                        this.worker.dispose();
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v15 == null) {
                        this.cancelled = true;
                        a15.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (!a15.tryOnNext(v15)) continue;
                    ++e15;
                }
                if (this.cancelled) {
                    return;
                }
                if (q15.isEmpty()) {
                    this.cancelled = true;
                    a15.onComplete();
                    this.worker.dispose();
                    return;
                }
                this.produced = e15;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        void runAsync() {
            int missed = 1;
            ConditionalSubscriber a15 = this.downstream;
            SimpleQueue q15 = this.queue;
            long emitted = this.produced;
            long polled = this.consumed;
            do {
                long r15 = this.requested.get();
                while (emitted != r15) {
                    boolean empty;
                    Object v15;
                    boolean d15 = this.done;
                    try {
                        v15 = q15.poll();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.cancelled = true;
                        this.upstream.cancel();
                        q15.clear();
                        a15.onError(ex4);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl4 = empty = v15 == null;
                    if (this.checkTerminated(d15, empty, a15)) {
                        return;
                    }
                    if (empty) break;
                    if (a15.tryOnNext(v15)) {
                        ++emitted;
                    }
                    if (++polled != (long)this.limit) continue;
                    this.upstream.request(polled);
                    polled = 0L;
                }
                if (emitted == r15 && this.checkTerminated(this.done, q15.isEmpty(), a15)) {
                    return;
                }
                this.produced = emitted;
                this.consumed = polled;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d15 = this.done;
                this.downstream.onNext(null);
                if (!d15) continue;
                this.cancelled = true;
                Throwable e15 = this.error;
                if (e15 != null) {
                    this.downstream.onError(e15);
                } else {
                    this.downstream.onComplete();
                }
                this.worker.dispose();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15 = this.queue.poll();
            if (v15 != null && this.sourceMode != 1) {
                long p15 = this.consumed + 1L;
                if (p15 == (long)this.limit) {
                    this.consumed = 0L;
                    this.upstream.request(p15);
                } else {
                    this.consumed = p15;
                }
            }
            return v15;
        }
    }

    static final class ObserveOnSubscriber<T>
    extends BaseObserveOnSubscriber<T> {
        private static final long serialVersionUID = -4547113800637756442L;
        final Subscriber<? super T> downstream;

        ObserveOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker, boolean delayError, int prefetch) {
            super(worker, delayError, prefetch);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription f15 = (QueueSubscription)s15;
                    int m15 = f15.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = 1;
                        this.queue = f15;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = 2;
                        this.queue = f15;
                        this.downstream.onSubscribe(this);
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.downstream.onSubscribe(this);
                s15.request(this.prefetch);
            }
        }

        @Override
        void runSync() {
            int missed = 1;
            Subscriber a15 = this.downstream;
            SimpleQueue q15 = this.queue;
            long e15 = this.produced;
            do {
                long r15 = this.requested.get();
                while (e15 != r15) {
                    Object v15;
                    try {
                        v15 = q15.poll();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.cancelled = true;
                        this.upstream.cancel();
                        a15.onError(ex4);
                        this.worker.dispose();
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v15 == null) {
                        this.cancelled = true;
                        a15.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    a15.onNext(v15);
                    ++e15;
                }
                if (this.cancelled) {
                    return;
                }
                if (q15.isEmpty()) {
                    this.cancelled = true;
                    a15.onComplete();
                    this.worker.dispose();
                    return;
                }
                this.produced = e15;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        void runAsync() {
            int missed = 1;
            Subscriber a15 = this.downstream;
            SimpleQueue q15 = this.queue;
            long e15 = this.produced;
            while (true) {
                long r15 = this.requested.get();
                while (e15 != r15) {
                    boolean empty;
                    Object v15;
                    boolean d15 = this.done;
                    try {
                        v15 = q15.poll();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.cancelled = true;
                        this.upstream.cancel();
                        q15.clear();
                        a15.onError(ex4);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl4 = empty = v15 == null;
                    if (this.checkTerminated(d15, empty, a15)) {
                        return;
                    }
                    if (empty) break;
                    a15.onNext(v15);
                    if (++e15 != (long)this.limit) continue;
                    if (r15 != Long.MAX_VALUE) {
                        r15 = this.requested.addAndGet(-e15);
                    }
                    this.upstream.request(e15);
                    e15 = 0L;
                }
                if (e15 == r15 && this.checkTerminated(this.done, q15.isEmpty(), a15)) {
                    return;
                }
                int w15 = this.get();
                if (missed == w15) {
                    this.produced = e15;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w15;
            }
        }

        @Override
        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d15 = this.done;
                this.downstream.onNext(null);
                if (!d15) continue;
                this.cancelled = true;
                Throwable e15 = this.error;
                if (e15 != null) {
                    this.downstream.onError(e15);
                } else {
                    this.downstream.onComplete();
                }
                this.worker.dispose();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15 = this.queue.poll();
            if (v15 != null && this.sourceMode != 1) {
                long p15 = this.produced + 1L;
                if (p15 == (long)this.limit) {
                    this.produced = 0L;
                    this.upstream.request(p15);
                } else {
                    this.produced = p15;
                }
            }
            return v15;
        }
    }

    static abstract class BaseObserveOnSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T>,
    Runnable {
        private static final long serialVersionUID = -8241002408341274697L;
        final Scheduler.Worker worker;
        final boolean delayError;
        final int prefetch;
        final int limit;
        final AtomicLong requested;
        Subscription upstream;
        SimpleQueue<T> queue;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        int sourceMode;
        long produced;
        boolean outputFused;

        BaseObserveOnSubscriber(Scheduler.Worker worker, boolean delayError, int prefetch) {
            this.worker = worker;
            this.delayError = delayError;
            this.prefetch = prefetch;
            this.requested = new AtomicLong();
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public final void onNext(T t15) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 2) {
                this.trySchedule();
                return;
            }
            if (!this.queue.offer(t15)) {
                this.upstream.cancel();
                this.error = new QueueOverflowException();
                this.done = true;
            }
            this.trySchedule();
        }

        @Override
        public final void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.error = t15;
            this.done = true;
            this.trySchedule();
        }

        @Override
        public final void onComplete() {
            if (!this.done) {
                this.done = true;
                this.trySchedule();
            }
        }

        @Override
        public final void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.trySchedule();
            }
        }

        @Override
        public final void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.upstream.cancel();
            this.worker.dispose();
            if (!this.outputFused && this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        final void trySchedule() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.worker.schedule(this);
        }

        @Override
        public final void run() {
            if (this.outputFused) {
                this.runBackfused();
            } else if (this.sourceMode == 1) {
                this.runSync();
            } else {
                this.runAsync();
            }
        }

        abstract void runBackfused();

        abstract void runSync();

        abstract void runAsync();

        final boolean checkTerminated(boolean d15, boolean empty, Subscriber<?> a15) {
            if (this.cancelled) {
                this.clear();
                return true;
            }
            if (d15) {
                if (this.delayError) {
                    if (empty) {
                        this.cancelled = true;
                        Throwable e15 = this.error;
                        if (e15 != null) {
                            a15.onError(e15);
                        } else {
                            a15.onComplete();
                        }
                        this.worker.dispose();
                        return true;
                    }
                } else {
                    Throwable e16 = this.error;
                    if (e16 != null) {
                        this.cancelled = true;
                        this.clear();
                        a15.onError(e16);
                        this.worker.dispose();
                        return true;
                    }
                    if (empty) {
                        this.cancelled = true;
                        a15.onComplete();
                        this.worker.dispose();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public final int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public final void clear() {
            this.queue.clear();
        }

        @Override
        public final boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

