/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;

public final class FlowableFromCallable<T>
extends Flowable<T>
implements Supplier<T> {
    final Callable<? extends T> callable;

    public FlowableFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        T t15;
        DeferredScalarSubscription<T> deferred = new DeferredScalarSubscription<T>(s15);
        s15.onSubscribe(deferred);
        try {
            t15 = Objects.requireNonNull(this.callable.call(), "The callable returned a null value");
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            if (deferred.isCancelled()) {
                RxJavaPlugins.onError(ex4);
            } else {
                s15.onError(ex4);
            }
            return;
        }
        deferred.complete(t15);
    }

    @Override
    public T get() throws Throwable {
        return Objects.requireNonNull(this.callable.call(), "The callable returned a null value");
    }
}

