/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDelaySubscriptionOther<T, U>
extends Flowable<T> {
    final Publisher<? extends T> main;
    final Publisher<U> other;

    public FlowableDelaySubscriptionOther(Publisher<? extends T> main, Publisher<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> child) {
        MainSubscriber<? extends T> parent = new MainSubscriber<T>(child, this.main);
        child.onSubscribe(parent);
        this.other.subscribe(parent.other);
    }

    static final class MainSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2259811067697317255L;
        final Subscriber<? super T> downstream;
        final Publisher<? extends T> main;
        final OtherSubscriber other;
        final AtomicReference<Subscription> upstream;

        MainSubscriber(Subscriber<? super T> downstream, Publisher<? extends T> main) {
            this.downstream = downstream;
            this.main = main;
            this.other = new OtherSubscriber();
            this.upstream = new AtomicReference();
        }

        void next() {
            this.main.subscribe(this);
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                SubscriptionHelper.deferredRequest(this.upstream, this, n15);
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.other);
            SubscriptionHelper.cancel(this.upstream);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this, s15);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<Object> {
            private static final long serialVersionUID = -3892798459447644106L;

            OtherSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription s15) {
                if (SubscriptionHelper.setOnce(this, s15)) {
                    s15.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(Object t15) {
                Subscription s15 = (Subscription)this.get();
                if (s15 != SubscriptionHelper.CANCELLED) {
                    this.lazySet(SubscriptionHelper.CANCELLED);
                    s15.cancel();
                    MainSubscriber.this.next();
                }
            }

            @Override
            public void onError(Throwable t15) {
                Subscription s15 = (Subscription)this.get();
                if (s15 != SubscriptionHelper.CANCELLED) {
                    MainSubscriber.this.downstream.onError(t15);
                } else {
                    RxJavaPlugins.onError(t15);
                }
            }

            @Override
            public void onComplete() {
                Subscription s15 = (Subscription)this.get();
                if (s15 != SubscriptionHelper.CANCELLED) {
                    MainSubscriber.this.next();
                }
            }
        }
    }
}

