/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableResumeNext
extends Completable {
    final CompletableSource source;
    final Function<? super Throwable, ? extends CompletableSource> errorMapper;

    public CompletableResumeNext(CompletableSource source, Function<? super Throwable, ? extends CompletableSource> errorMapper) {
        this.source = source;
        this.errorMapper = errorMapper;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        ResumeNextObserver parent = new ResumeNextObserver(observer, this.errorMapper);
        observer.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class ResumeNextObserver
    extends AtomicReference<Disposable>
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = 5018523762564524046L;
        final CompletableObserver downstream;
        final Function<? super Throwable, ? extends CompletableSource> errorMapper;
        boolean once;

        ResumeNextObserver(CompletableObserver observer, Function<? super Throwable, ? extends CompletableSource> errorMapper) {
            this.downstream = observer;
            this.errorMapper = errorMapper;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.replace(this, d15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e15) {
            CompletableSource c15;
            if (this.once) {
                this.downstream.onError(e15);
                return;
            }
            this.once = true;
            try {
                c15 = Objects.requireNonNull(this.errorMapper.apply(e15), "The errorMapper returned a null CompletableSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(new CompositeException(e15, ex4));
                return;
            }
            c15.subscribe(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }
}

