/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.AbstractDisposableAutoRelease;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class DisposableAutoReleaseMultiObserver<T>
extends AbstractDisposableAutoRelease
implements SingleObserver<T>,
MaybeObserver<T>,
CompletableObserver {
    private static final long serialVersionUID = 8924480688481408726L;
    final Consumer<? super T> onSuccess;

    public DisposableAutoReleaseMultiObserver(DisposableContainer composite, Consumer<? super T> onSuccess, Consumer<? super Throwable> onError, Action onComplete) {
        super(composite, onError, onComplete);
        this.onSuccess = onSuccess;
    }

    @Override
    public void onSuccess(T t15) {
        if (this.get() != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onSuccess.accept(t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(e15);
            }
        }
        this.removeSelf();
    }
}

