/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

abstract class ObservableStageObserver<T>
extends CompletableFuture<T>
implements Observer<T> {
    final AtomicReference<Disposable> upstream = new AtomicReference();
    T value;

    ObservableStageObserver() {
    }

    @Override
    public final void onSubscribe(@NonNull Disposable d15) {
        DisposableHelper.setOnce(this.upstream, d15);
    }

    @Override
    public final void onError(Throwable t15) {
        this.clear();
        if (!this.completeExceptionally(t15)) {
            RxJavaPlugins.onError(t15);
        }
    }

    protected final void disposeUpstream() {
        DisposableHelper.dispose(this.upstream);
    }

    protected final void clear() {
        this.value = null;
        this.upstream.lazySet(DisposableHelper.DISPOSED);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.disposeUpstream();
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean complete(T value) {
        this.disposeUpstream();
        return super.complete(value);
    }

    @Override
    public final boolean completeExceptionally(Throwable ex4) {
        this.disposeUpstream();
        return super.completeExceptionally(ex4);
    }
}

