/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.Validate;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream inputStream) {
        super(Validate.notNull(inputStream, "stream"));
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n15 = this.in.read();
        if (n15 < 0) {
            throw new EOFException();
        }
        return n15 != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n15 = this.in.read();
        if (n15 < 0) {
            throw new EOFException();
        }
        return (byte)n15;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n15 = this.in.read();
        if (n15 < 0) {
            throw new EOFException();
        }
        return n15;
    }

    @Override
    public short readShort() throws IOException {
        int n15 = this.in.read();
        int n16 = this.in.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        return (short)(n16 << 24 >>> 16 | n15 << 24 >>> 24);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n15 = this.in.read();
        int n16 = this.in.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        return (n16 << 8) + n15;
    }

    @Override
    public char readChar() throws IOException {
        int n15 = this.in.read();
        int n16 = this.in.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        return (char)(n16 << 24 >>> 16 | n15 << 24 >>> 24);
    }

    @Override
    public int readInt() throws IOException {
        int n15 = this.in.read();
        int n16 = this.in.read();
        int n17 = this.in.read();
        int n18 = this.in.read();
        if (n18 < 0) {
            throw new EOFException();
        }
        return n18 << 24 | n17 << 24 >>> 8 | n16 << 24 >>> 16 | n15 << 24 >>> 24;
    }

    @Override
    public long readLong() throws IOException {
        long l15 = this.in.read();
        long l16 = this.in.read();
        long l17 = this.in.read();
        long l18 = this.in.read();
        long l19 = this.in.read();
        long l25 = this.in.read();
        long l26 = this.in.read();
        long l27 = this.in.read();
        if (l27 < 0L) {
            throw new EOFException();
        }
        return l27 << 56 | l26 << 56 >>> 8 | l25 << 56 >>> 16 | l19 << 56 >>> 24 | l18 << 56 >>> 32 | l17 << 56 >>> 40 | l16 << 56 >>> 48 | l15 << 56 >>> 56;
    }

    @Override
    public String readUTF() throws IOException {
        int n15 = this.in.read();
        int n16 = this.in.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        int n17 = (n15 << 8) + n16;
        char[] cArray = new char[n17];
        int n18 = 0;
        int n19 = 0;
        while (n18 < n17) {
            int n25;
            int n26 = this.readUnsignedByte();
            int n27 = n26 >> 4;
            if (n27 < 8) {
                ++n18;
                cArray[n19++] = (char)n26;
                continue;
            }
            if (n27 == 12 || n27 == 13) {
                if ((n18 += 2) > n17) {
                    throw new UTFDataFormatException();
                }
                n25 = this.readUnsignedByte();
                if ((n25 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n19++] = (char)((n26 & 0x1F) << 6 | n25 & 0x3F);
                continue;
            }
            if (n27 == 14) {
                if ((n18 += 3) > n17) {
                    throw new UTFDataFormatException();
                }
                n25 = this.readUnsignedByte();
                int n28 = this.readUnsignedByte();
                if ((n25 & 0xC0) != 128 || (n28 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n19++] = (char)((n26 & 0xF) << 12 | (n25 & 0x3F) << 6 | n28 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n19);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final int skipBytes(int n15) throws IOException {
        int n16;
        int n17;
        for (n16 = 0; n16 < n15 && (n17 = (int)this.in.skip(n15 - n16)) > 0; n16 += n17) {
        }
        return n16;
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n15, int n16) throws IOException {
        int n17;
        if (n16 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i15 = 0; i15 < n16; i15 += n17) {
            n17 = this.in.read(byArray, n15 + i15, n16 - i15);
            if (n17 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.in);
        return dataInputStream.readLine();
    }
}

