/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.BufferedImageIcon;
import com.twelvemonkeys.image.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class AreaAverageOp
implements BufferedImageOp,
RasterOp {
    private final int width;
    private final int height;
    private Rectangle sourceRegion;

    public AreaAverageOp(int n15, int n16) {
        this.width = n15;
        this.height = n16;
    }

    public Rectangle getSourceRegion() {
        if (this.sourceRegion == null) {
            return null;
        }
        return new Rectangle(this.sourceRegion);
    }

    public void setSourceRegion(Rectangle rectangle) {
        if (rectangle == null) {
            this.sourceRegion = null;
        } else if (this.sourceRegion == null) {
            this.sourceRegion = new Rectangle(rectangle);
        } else {
            this.sourceRegion.setBounds(rectangle);
        }
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        BufferedImage bufferedImage3 = bufferedImage2 != null ? bufferedImage2 : this.createCompatibleDestImage(bufferedImage, null);
        long l15 = System.currentTimeMillis();
        this.filterImpl(bufferedImage.getRaster(), bufferedImage3.getRaster());
        long l16 = System.currentTimeMillis() - l15;
        System.out.println("time: " + l16);
        return bufferedImage3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resample(BufferedImage bufferedImage, BufferedImage bufferedImage2, AffineTransform affineTransform) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            graphics2D.drawImage(bufferedImage, affineTransform, null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        WritableRaster writableRaster2 = writableRaster != null ? writableRaster : this.createCompatibleDestRaster(raster);
        return this.filterImpl(raster, writableRaster2);
    }

    private WritableRaster filterImpl(Raster raster, WritableRaster writableRaster) {
        boolean bl4;
        int n15;
        int n16;
        int n17;
        int n18;
        if (this.sourceRegion != null) {
            n18 = this.sourceRegion.x;
            n17 = this.sourceRegion.y;
            n16 = this.sourceRegion.width;
            n15 = this.sourceRegion.height;
            bl4 = raster == writableRaster;
            writableRaster = writableRaster.createWritableChild(n18, n17, n16, n15, 0, 0, null);
            raster = bl4 ? writableRaster : raster.createChild(n18, n17, n16, n15, 0, 0, null);
        }
        n18 = raster.getWidth();
        n17 = raster.getHeight();
        n16 = (n18 + this.width - 1) / this.width;
        n15 = (n17 + this.height - 1) / this.height;
        bl4 = n18 % this.width != 0;
        boolean bl5 = n17 % this.height != 0;
        int n19 = raster.getNumDataElements();
        int n25 = raster.getNumBands();
        int n26 = raster.getTransferType();
        Object object = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (raster.getTransferType() == 1) {
            if (raster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
                nArray = singlePixelPackedSampleModel.getBitMasks();
                nArray2 = singlePixelPackedSampleModel.getBitOffsets();
            } else {
                nArray = new int[]{65535};
                nArray2 = new int[]{0};
            }
        }
        for (int i15 = 0; i15 < this.height; ++i15) {
            int n27 = !bl5 || i15 < this.height ? n15 : n17 - i15 * n15;
            for (int i16 = 0; i16 < this.width; ++i16) {
                int n28 = !bl4 || i16 < this.width ? n16 : n18 - i16 * n16;
                int n29 = n28 * n27;
                int n35 = n29 * n19;
                try {
                    object = raster.getDataElements(i16 * n16, i15 * n15, n28, n27, object);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                double d15 = 0.0;
                double d16 = 0.0;
                double d17 = 0.0;
                double d18 = 0.0;
                switch (n26) {
                    case 0: {
                        byte[] byArray = (byte[])object;
                        for (int i17 = 0; i17 < n35; i17 += n19) {
                            d15 += (double)(byArray[i17] & 0xFF);
                            if (n25 <= 1) continue;
                            d16 += (double)(byArray[i17 + 1] & 0xFF);
                            d17 += (double)(byArray[i17 + 2] & 0xFF);
                            if (n25 <= 3) continue;
                            d18 += (double)(byArray[i17 + 3] & 0xFF);
                        }
                        d15 /= (double)n29;
                        if (n25 > 1) {
                            d16 /= (double)n29;
                            d17 /= (double)n29;
                            if (n25 > 3) {
                                d18 /= (double)n29;
                            }
                        }
                        byArray[0] = (byte)AreaAverageOp.clamp((int)d15);
                        if (n25 <= 1) break;
                        byArray[1] = (byte)AreaAverageOp.clamp((int)d16);
                        byArray[2] = (byte)AreaAverageOp.clamp((int)d17);
                        if (n25 <= 3) break;
                        byArray[3] = (byte)AreaAverageOp.clamp((int)d18);
                        break;
                    }
                    case 3: {
                        int[] nArray3 = (int[])object;
                        for (int i18 = 0; i18 < n35; i18 += n19) {
                            d15 += (double)((nArray3[i18] & 0xFF000000) >> 24);
                            d16 += (double)((nArray3[i18] & 0xFF0000) >> 16);
                            d17 += (double)((nArray3[i18] & 0xFF00) >> 8);
                            d18 += (double)(nArray3[i18] & 0xFF);
                        }
                        nArray3[0] = AreaAverageOp.clamp((int)(d15 /= (double)n29)) << 24;
                        nArray3[0] = nArray3[0] | AreaAverageOp.clamp((int)(d16 /= (double)n29)) << 16;
                        nArray3[0] = nArray3[0] | AreaAverageOp.clamp((int)(d17 /= (double)n29)) << 8;
                        nArray3[0] = nArray3[0] | AreaAverageOp.clamp((int)(d18 /= (double)n29));
                        break;
                    }
                    case 1: {
                        if (nArray != null) {
                            short[] sArray = (short[])object;
                            for (int i19 = 0; i19 < n35; i19 += n19) {
                                d15 += (double)((sArray[i19] & nArray[0]) >> nArray2[0]);
                                if (nArray.length <= 1) continue;
                                d16 += (double)((sArray[i19] & nArray[1]) >> nArray2[1]);
                                d17 += (double)((sArray[i19] & nArray[2]) >> nArray2[2]);
                                if (nArray.length <= 3) continue;
                                d18 += (double)((sArray[i19] & nArray[3]) >> nArray2[3]);
                            }
                            d16 /= (double)n29;
                            d17 /= (double)n29;
                            d18 /= (double)n29;
                            sArray[0] = (short)((int)(d15 /= (double)n29) << nArray2[0] & nArray[0]);
                            if (nArray.length <= 1) break;
                            sArray[0] = (short)(sArray[0] | (short)((int)d16 << nArray2[1] & nArray[1]));
                            sArray[0] = (short)(sArray[0] | (short)((int)d17 << nArray2[2] & nArray[2]));
                            if (nArray.length <= 3) break;
                            sArray[0] = (short)(sArray[0] | (short)((int)d18 << nArray2[3] & nArray[3]));
                            break;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("TransferType not supported: " + n26);
                    }
                }
                writableRaster.setDataElements(i16, i15, 1, 1, object);
            }
        }
        return writableRaster;
    }

    private static int clamp(int n15) {
        return n15 > 255 ? 255 : n15;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        ColorModel colorModel2 = colorModel != null ? colorModel : bufferedImage.getColorModel();
        return new BufferedImage(colorModel2, ImageUtil.createCompatibleWritableRaster(bufferedImage, colorModel2, this.width, this.height), colorModel2.isAlphaPremultiplied(), null);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster(this.width, this.height);
    }

    @Override
    public Rectangle2D getBounds2D(Raster raster) {
        return new Rectangle(this.width, this.height);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(this.width, this.height);
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File("2006-Lamborghini-Gallardo-Spyder-Y-T-1600x1200.png"));
        for (int i15 = 0; i15 < 100; ++i15) {
        }
        long l15 = System.currentTimeMillis();
        bufferedImage = new AreaAverageOp(500, 600).filter(bufferedImage, null);
        long l16 = System.currentTimeMillis() - l15;
        System.out.println("time: " + l16 + " ms");
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new JScrollPane(new JLabel(new BufferedImageIcon(bufferedImage))));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

