/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;

@GwtCompatible
final class MathPreconditions {
    @CanIgnoreReturnValue
    static int checkPositive(String role, int x15) {
        if (x15 <= 0) {
            throw new IllegalArgumentException(role + " (" + x15 + ") must be > 0");
        }
        return x15;
    }

    @CanIgnoreReturnValue
    static long checkPositive(String role, long x15) {
        if (x15 <= 0L) {
            throw new IllegalArgumentException(role + " (" + x15 + ") must be > 0");
        }
        return x15;
    }

    @CanIgnoreReturnValue
    static BigInteger checkPositive(String role, BigInteger x15) {
        if (x15.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x15 + ") must be > 0");
        }
        return x15;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(String role, int x15) {
        if (x15 < 0) {
            throw new IllegalArgumentException(role + " (" + x15 + ") must be >= 0");
        }
        return x15;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(String role, long x15) {
        if (x15 < 0L) {
            throw new IllegalArgumentException(role + " (" + x15 + ") must be >= 0");
        }
        return x15;
    }

    @CanIgnoreReturnValue
    static BigInteger checkNonNegative(String role, BigInteger x15) {
        if (x15.signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x15 + ") must be >= 0");
        }
        return x15;
    }

    @CanIgnoreReturnValue
    static double checkNonNegative(String role, double x15) {
        if (!(x15 >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x15 + ") must be >= 0");
        }
        return x15;
    }

    static void checkRoundingUnnecessary(boolean condition2) {
        if (!condition2) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition2, double input, RoundingMode mode) {
        if (!condition2) {
            throw new ArithmeticException("rounded value is out of range for input " + input + " and rounding mode " + (Object)((Object)mode));
        }
    }

    static void checkNoOverflow(boolean condition2, String methodName, int a15, int b15) {
        if (!condition2) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a15 + ", " + b15 + ")");
        }
    }

    static void checkNoOverflow(boolean condition2, String methodName, long a15, long b15) {
        if (!condition2) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a15 + ", " + b15 + ")");
        }
    }

    private MathPreconditions() {
    }
}

