/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Platform;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected UnicodeEscaper() {
    }

    protected abstract char @Nullable [] escape(int var1);

    @Override
    public String escape(String string) {
        Preconditions.checkNotNull(string);
        int end = string.length();
        int index = this.nextEscapeIndex(string, 0, end);
        return index == end ? string : this.escapeSlow(string, index);
    }

    protected int nextEscapeIndex(CharSequence csq, int start, int end) {
        int index;
        int cp4;
        for (index = start; index < end && (cp4 = UnicodeEscaper.codePointAt(csq, index, end)) >= 0 && this.escape(cp4) == null; index += Character.isSupplementaryCodePoint(cp4) ? 2 : 1) {
        }
        return index;
    }

    protected final String escapeSlow(String s15, int index) {
        int end = s15.length();
        char[] dest = Platform.charBufferFromThreadLocal();
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index < end) {
            int cp4 = UnicodeEscaper.codePointAt(s15, index, end);
            if (cp4 < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped = this.escape(cp4);
            int nextIndex = index + (Character.isSupplementaryCodePoint(cp4) ? 2 : 1);
            if (escaped != null) {
                int charsSkipped = index - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end - index) + 32;
                    dest = UnicodeEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s15.getChars(unescapedChunkStart, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy(escaped, 0, dest, destIndex, escaped.length);
                    destIndex += escaped.length;
                }
                unescapedChunkStart = nextIndex;
            }
            index = this.nextEscapeIndex(s15, nextIndex, end);
        }
        int charsSkipped = end - unescapedChunkStart;
        if (charsSkipped > 0) {
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = UnicodeEscaper.growBuffer(dest, destIndex, endIndex);
            }
            s15.getChars(unescapedChunkStart, end, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    protected static int codePointAt(CharSequence seq, int index, int end) {
        Preconditions.checkNotNull(seq);
        if (index < end) {
            char c15;
            if ((c15 = seq.charAt(index++)) < '\ud800' || c15 > '\udfff') {
                return c15;
            }
            if (c15 <= '\udbff') {
                if (index == end) {
                    return -c15;
                }
                char c25 = seq.charAt(index);
                if (Character.isLowSurrogate(c25)) {
                    return Character.toCodePoint(c15, c25);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c25 + "' with value " + c25 + " at index " + index + " in '" + seq + "'");
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c15 + "' with value " + c15 + " at index " + (index - 1) + " in '" + seq + "'");
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] dest, int index, int size) {
        if (size < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] copy = new char[size];
        if (index > 0) {
            System.arraycopy(dest, 0, copy, 0, index);
        }
        return copy;
    }
}

