/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.function.Function;
import javax.swing.JComponent;

public class MigLayoutVisualPadding {
    public static String VISUAL_PADDING_PROPERTY = "visualPadding";
    private static final FlatMigInsets ZERO = new FlatMigInsets(0, 0, 0, 0);
    private static final boolean migLayoutAvailable;

    public static void install(JComponent c15, Insets insets) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.setVisualPadding(c15, insets);
    }

    public static void install(JComponent c15) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.install(c15, c25 -> {
            FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c25);
            if (border != null) {
                int focusWidth = border.getFocusWidth((Component)c25);
                return new Insets(focusWidth, focusWidth, focusWidth, focusWidth);
            }
            return null;
        }, "border", "FlatLaf.style", "FlatLaf.styleClass");
    }

    public static void install(JComponent c15, Function<JComponent, Insets> getPaddingFunction, String ... propertyNames) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.setVisualPadding(c15, getPaddingFunction.apply(c15));
        c15.addPropertyChangeListener(e15 -> {
            String propertyName = e15.getPropertyName();
            for (String name : propertyNames) {
                if (!name.equals(propertyName)) continue;
                MigLayoutVisualPadding.setVisualPadding(c15, (Insets)getPaddingFunction.apply(c15));
                break;
            }
        });
    }

    private static void setVisualPadding(JComponent c15, Insets visualPadding) {
        Object oldPadding = c15.getClientProperty(VISUAL_PADDING_PROPERTY);
        if (oldPadding == null || oldPadding instanceof FlatMigInsets) {
            FlatMigInsets flatVisualPadding = visualPadding != null ? new FlatMigInsets(UIScale.scale2(visualPadding.top), UIScale.scale2(visualPadding.left), UIScale.scale2(visualPadding.bottom), UIScale.scale2(visualPadding.right)) : ZERO;
            c15.putClientProperty(VISUAL_PADDING_PROPERTY, flatVisualPadding);
        }
    }

    public static void uninstall(JComponent c15) {
        if (!migLayoutAvailable) {
            return;
        }
        for (PropertyChangeListener l15 : c15.getPropertyChangeListeners()) {
            if (!(l15 instanceof FlatMigListener)) continue;
            c15.removePropertyChangeListener(l15);
            break;
        }
        if (c15.getClientProperty(VISUAL_PADDING_PROPERTY) instanceof FlatMigInsets) {
            c15.putClientProperty(VISUAL_PADDING_PROPERTY, null);
        }
    }

    static {
        boolean available = false;
        try {
            Class.forName("net.miginfocom.swing.MigLayout");
            available = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        migLayoutAvailable = available;
    }

    private static interface FlatMigListener
    extends PropertyChangeListener {
    }

    private static class FlatMigInsets
    extends Insets {
        FlatMigInsets(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }
    }
}

