/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class FlatProgressBarUI
extends BasicProgressBarUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int arc;
    @FlatStylingSupport.Styleable
    protected Dimension horizontalSize;
    @FlatStylingSupport.Styleable
    protected Dimension verticalSize;
    @FlatStylingSupport.Styleable
    protected boolean largeHeight;
    @FlatStylingSupport.Styleable
    protected boolean square;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatProgressBarUI();
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent c15) {
        if (!EventQueue.isDispatchThread() && this.progressBar.isIndeterminate()) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Uninstalling indeterminate progress bar UI not on AWT thread may throw NPE in FlatProgressBarUI.paint(). Use SwingUtilities.invokeLater().", new IllegalStateException());
        }
        super.uninstallUI(c15);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.progressBar, "opaque", false);
        this.arc = UIManager.getInt("ProgressBar.arc");
        this.horizontalSize = UIManager.getDimension("ProgressBar.horizontalSize");
        this.verticalSize = UIManager.getDimension("ProgressBar.verticalSize");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = e15 -> {
            switch (e15.getPropertyName()) {
                case "indeterminate": {
                    if (EventQueue.isDispatchThread() || this.progressBar.isIndeterminate()) break;
                    LoggingFacade.INSTANCE.logSevere("FlatLaf: Using JProgressBar.setIndeterminate(false) not on AWT thread may throw NPE in FlatProgressBarUI.paint(). Use SwingUtilities.invokeLater().", new IllegalStateException());
                    break;
                }
                case "JProgressBar.largeHeight": 
                case "JProgressBar.square": {
                    this.progressBar.revalidate();
                    HiDPIUtils.repaint(this.progressBar);
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.progressBar.revalidate();
                    HiDPIUtils.repaint(this.progressBar);
                }
            }
        };
        this.progressBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.progressBar, "ProgressBar"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.progressBar, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        Dimension size = super.getPreferredSize(c15);
        if (this.progressBar.isStringPainted() || FlatClientProperties.clientPropertyBoolean(c15, "JProgressBar.largeHeight", this.largeHeight)) {
            Insets insets = this.progressBar.getInsets();
            FontMetrics fm4 = this.progressBar.getFontMetrics(this.progressBar.getFont());
            if (this.progressBar.getOrientation() == 0) {
                size.height = Math.max(fm4.getHeight() + insets.top + insets.bottom, this.getPreferredInnerHorizontal().height);
            } else {
                size.width = Math.max(fm4.getHeight() + insets.left + insets.right, this.getPreferredInnerVertical().width);
            }
        }
        return size;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return UIScale.scale(this.horizontalSize);
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        return UIScale.scale(this.verticalSize);
    }

    @Override
    public void update(Graphics g15, JComponent c15) {
        if (c15.isOpaque()) {
            FlatUIUtils.paintParentBackground(g15, c15);
        }
        this.paint(g15, c15);
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        boolean horizontal;
        Insets insets = this.progressBar.getInsets();
        int x15 = insets.left;
        int y15 = insets.top;
        int width = this.progressBar.getWidth() - (insets.right + insets.left);
        int height = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean bl4 = horizontal = this.progressBar.getOrientation() == 0;
        int arc = FlatClientProperties.clientPropertyBoolean(c15, "JProgressBar.square", this.square) ? 0 : Math.min(UIScale.scale(this.arc), horizontal ? height : width);
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
        RoundRectangle2D.Float trackShape = new RoundRectangle2D.Float(x15, y15, width, height, arc, arc);
        g15.setColor(this.progressBar.getBackground());
        ((Graphics2D)g15).fill(trackShape);
        int amountFull = 0;
        if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                g15.setColor(this.progressBar.getForeground());
                ((Graphics2D)g15).fill(new RoundRectangle2D.Float(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, arc, arc));
            }
        } else {
            amountFull = this.getAmountFull(insets, width, height);
            RoundRectangle2D.Float progressShape = horizontal ? new RoundRectangle2D.Float(c15.getComponentOrientation().isLeftToRight() ? (float)x15 : (float)(x15 + (width - amountFull)), y15, amountFull, height, arc, arc) : new RoundRectangle2D.Float(x15, y15 + (height - amountFull), width, amountFull, arc, arc);
            g15.setColor(this.progressBar.getForeground());
            if (amountFull < (horizontal ? height : width)) {
                Area area = new Area(trackShape);
                area.intersect(new Area(progressShape));
                ((Graphics2D)g15).fill(area);
            } else {
                ((Graphics2D)g15).fill(progressShape);
            }
        }
        FlatUIUtils.resetRenderingHints(g15, oldRenderingHints);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g15, x15, y15, width, height, amountFull, insets);
        }
    }

    @Override
    protected void paintString(Graphics g15, int x15, int y15, int width, int height, int amountFull, Insets b15) {
        super.paintString(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)g15), x15, y15, width, height, amountFull, b15);
    }

    @Override
    protected void setAnimationIndex(int newValue) {
        super.setAnimationIndex(newValue);
        double systemScaleFactor = UIScale.getSystemScaleFactor(this.progressBar.getGraphicsConfiguration());
        if ((double)((int)systemScaleFactor) != systemScaleFactor) {
            HiDPIUtils.repaint(this.progressBar);
        }
    }
}

