/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatNativeLibrary;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class FlatNativeLinuxLibrary {
    private static int API_VERSION_LINUX = 3003;
    static final int SIZE_TOPLEFT = 0;
    static final int SIZE_TOP = 1;
    static final int SIZE_TOPRIGHT = 2;
    static final int SIZE_RIGHT = 3;
    static final int SIZE_BOTTOMRIGHT = 4;
    static final int SIZE_BOTTOM = 5;
    static final int SIZE_BOTTOMLEFT = 6;
    static final int SIZE_LEFT = 7;
    static final int MOVE = 8;
    private static Boolean isXWindowSystem;
    private static Boolean isGtk3Available;
    public static final int FC_select_folder = 1;
    public static final int FC_select_multiple = 2;
    public static final int FC_show_hidden = 4;
    public static final int FC_local_only = 8;
    public static final int FC_do_overwrite_confirmation = 16;
    public static final int FC_create_folders = 32;

    public static boolean isLoaded() {
        return SystemInfo.isLinux && FlatNativeLibrary.isLoaded(API_VERSION_LINUX);
    }

    private static boolean isXWindowSystem() {
        if (isXWindowSystem == null) {
            isXWindowSystem = Toolkit.getDefaultToolkit().getClass().getName().endsWith(".XToolkit");
        }
        return isXWindowSystem;
    }

    static boolean isWMUtilsSupported(Window window) {
        return FlatNativeLinuxLibrary.hasCustomDecoration(window) && FlatNativeLinuxLibrary.isXWindowSystem() && FlatNativeLinuxLibrary.isLoaded();
    }

    static boolean moveOrResizeWindow(Window window, MouseEvent e15, int direction) {
        Point pt4 = FlatNativeLinuxLibrary.scale(window, e15.getLocationOnScreen());
        return FlatNativeLinuxLibrary.xMoveOrResizeWindow(window, pt4.x, pt4.y, direction);
    }

    static boolean showWindowMenu(Window window, MouseEvent e15) {
        Point pt4 = FlatNativeLinuxLibrary.scale(window, e15.getLocationOnScreen());
        return FlatNativeLinuxLibrary.xShowWindowMenu(window, pt4.x, pt4.y);
    }

    private static Point scale(Window window, Point pt4) {
        GraphicsConfiguration gc5 = window.getGraphicsConfiguration();
        if (gc5 == null) {
            return pt4;
        }
        AffineTransform transform = gc5.getDefaultTransform();
        int x15 = (int)Math.round((double)pt4.x * transform.getScaleX());
        int y15 = (int)Math.round((double)pt4.y * transform.getScaleY());
        return new Point(x15, y15);
    }

    private static native boolean xMoveOrResizeWindow(Window var0, int var1, int var2, int var3);

    private static native boolean xShowWindowMenu(Window var0, int var1, int var2);

    private static boolean hasCustomDecoration(Window window) {
        return window instanceof JFrame && JFrame.isDefaultLookAndFeelDecorated() && ((JFrame)window).isUndecorated() || window instanceof JDialog && JDialog.isDefaultLookAndFeelDecorated() && ((JDialog)window).isUndecorated();
    }

    public static boolean isGtk3Available() {
        if (isGtk3Available == null) {
            isGtk3Available = FlatNativeLinuxLibrary.isLibAvailable("libgtk-3.so.0") || FlatNativeLinuxLibrary.isLibAvailable("libgtk-3.so");
        }
        return isGtk3Available;
    }

    private static native boolean isLibAvailable(String var0);

    public static native String[] showFileChooser(Window var0, int var1, boolean var2, String var3, String var4, String var5, String var6, int var7, int var8, FileChooserCallback var9, int var10, String ... var11);

    public static native int showMessageDialog(long var0, int var2, String var3, String var4, int var5, String ... var6);

    public static interface FileChooserCallback {
        public boolean approve(String[] var1, long var2);
    }
}

