/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.ArraySortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class CollectionUtils {
    public static <T> int listHashCode(@Nonnull Iterable<T> iterable) {
        int hashCode = 1;
        for (T item : iterable) {
            hashCode = hashCode * 31 + item.hashCode();
        }
        return hashCode;
    }

    public static <T> int lastIndexOf(@Nonnull Iterable<T> iterable, @Nonnull Predicate<? super T> predicate) {
        int index = 0;
        int lastMatchingIndex = -1;
        for (T item : iterable) {
            if (predicate.test(item)) {
                lastMatchingIndex = index;
            }
            ++index;
        }
        return lastMatchingIndex;
    }

    public static <T extends Comparable<? super T>> int compareAsList(@Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res = Integer.compare(list1.size(), list2.size());
        if (res != 0) {
            return res;
        }
        Iterator<T> elements2 = list2.iterator();
        for (Comparable element1 : list1) {
            res = element1.compareTo(elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int compareAsIterable(@Nonnull Comparator<? super T> comparator, @Nonnull Iterable<? extends T> it12, @Nonnull Iterable<? extends T> it22) {
        Iterator<T> elements2 = it22.iterator();
        for (T element1 : it12) {
            if (!elements2.hasNext()) {
                return 1;
            }
            T element2 = elements2.next();
            int res = comparator.compare(element1, element2);
            if (res == 0) continue;
            return res;
        }
        if (elements2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compareAsIterable(@Nonnull Iterable<? extends T> it12, @Nonnull Iterable<? extends T> it22) {
        Iterator<T> elements2 = it22.iterator();
        for (Comparable element1 : it12) {
            if (!elements2.hasNext()) {
                return 1;
            }
            Comparable element2 = (Comparable)elements2.next();
            int res = element1.compareTo(element2);
            if (res == 0) continue;
            return res;
        }
        if (elements2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T> int compareAsList(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res = Integer.compare(list1.size(), list2.size());
        if (res != 0) {
            return res;
        }
        Iterator<T> elements2 = list2.iterator();
        for (T element1 : list1) {
            res = elementComparator.compare(element1, elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Nonnull
    public static <T> Comparator<Collection<? extends T>> listComparator(final @Nonnull Comparator<? super T> elementComparator) {
        return new Comparator<Collection<? extends T>>(){

            @Override
            public int compare(Collection<? extends T> list1, Collection<? extends T> list2) {
                return CollectionUtils.compareAsList(elementComparator, list1, list2);
            }
        };
    }

    public static <T> boolean isNaturalSortedSet(@Nonnull Iterable<? extends T> it) {
        if (it instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)it;
            Comparator comparator = sortedSet.comparator();
            return comparator == null || comparator.equals(NaturalOrdering.INSTANCE);
        }
        return false;
    }

    public static <T> boolean isSortedSet(@Nonnull Comparator<? extends T> elementComparator, @Nonnull Iterable<? extends T> it) {
        if (it instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)it;
            Comparator comparator = sortedSet.comparator();
            if (comparator == null) {
                return elementComparator.equals(NaturalOrdering.INSTANCE);
            }
            return elementComparator.equals(comparator);
        }
        return false;
    }

    @Nonnull
    private static <T> SortedSet<? extends T> toNaturalSortedSet(@Nonnull Collection<? extends T> collection) {
        if (CollectionUtils.isNaturalSortedSet(collection)) {
            return (SortedSet)collection;
        }
        ArraySortedSet<Object> sortedSet = ArraySortedSet.of(NaturalOrdering.INSTANCE, collection.toArray());
        return Collections.unmodifiableSortedSet(sortedSet);
    }

    @Nonnull
    private static <T> SortedSet<? extends T> toSortedSet(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> collection) {
        SortedSet sortedSet;
        Comparator comparator;
        if (collection instanceof SortedSet && (comparator = (sortedSet = (SortedSet)collection).comparator()) != null && comparator.equals(elementComparator)) {
            return sortedSet;
        }
        return Collections.unmodifiableSortedSet(ArraySortedSet.of(elementComparator, collection));
    }

    @Nonnull
    public static <T> Comparator<Collection<? extends T>> setComparator(final @Nonnull Comparator<? super T> elementComparator) {
        return new Comparator<Collection<? extends T>>(){

            @Override
            public int compare(Collection<? extends T> list1, Collection<? extends T> list2) {
                return CollectionUtils.compareAsSet(elementComparator, list1, list2);
            }
        };
    }

    public static <T extends Comparable<T>> int compareAsSet(@Nonnull Collection<? extends T> set1, @Nonnull Collection<? extends T> set2) {
        int res = Integer.compare(set1.size(), set2.size());
        if (res != 0) {
            return res;
        }
        SortedSet<? extends T> sortedSet1 = CollectionUtils.toNaturalSortedSet(set1);
        SortedSet<? extends T> sortedSet2 = CollectionUtils.toNaturalSortedSet(set2);
        Iterator<T> elements2 = set2.iterator();
        for (Comparable element1 : set1) {
            res = element1.compareTo((Comparable)elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int compareAsSet(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res = Integer.compare(list1.size(), list2.size());
        if (res != 0) {
            return res;
        }
        SortedSet set1 = CollectionUtils.toSortedSet(elementComparator, list1);
        SortedSet set2 = CollectionUtils.toSortedSet(elementComparator, list2);
        Iterator elements2 = set2.iterator();
        for (Object element1 : set1) {
            res = elementComparator.compare(element1, elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> List<T> immutableSortedCopy(@Nonnull Collection<T> collection, @Nonnull Comparator<? super T> comparator) {
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.sort(comparator);
        return Collections.unmodifiableList(copy);
    }

    public static <T> Comparator<? super T> usingToStringOrdering() {
        return UsingToStringOrdering.INSTANCE;
    }

    public static <T> Comparator<? super T> naturalOrdering() {
        return NaturalOrdering.INSTANCE;
    }

    public static final class NaturalOrdering<T extends Comparable<? super T>>
    implements Comparator<T> {
        static final NaturalOrdering INSTANCE = new NaturalOrdering();

        @Override
        public int compare(T left, T right) {
            return left.compareTo(right);
        }

        private NaturalOrdering() {
        }
    }

    public static final class UsingToStringOrdering<T>
    implements Comparator<T> {
        static final UsingToStringOrdering INSTANCE = new UsingToStringOrdering();

        @Override
        public int compare(Object left, Object right) {
            return left.toString().compareTo(right.toString());
        }

        private UsingToStringOrdering() {
        }
    }
}

