/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.model.ModuleEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.zipflinger.Entry;
import shadow.bundletool.com.android.zipflinger.ZipArchive;
import shadow.bundletool.com.android.zipflinger.ZipMap;
import shadow.bundletool.com.android.zipflinger.ZipSource;

class ModuleEntriesPack {
    private final ImmutableSet<String> namePrefixes;
    private final ZipMap zipMap;
    private final IdentityHashMap<ModuleEntry, String> entryNameByModuleEntry;

    ModuleEntriesPack(ImmutableSet<String> namePrefixes, ZipMap zipMap, IdentityHashMap<ModuleEntry, String> entryNameByModuleEntry) {
        this.namePrefixes = namePrefixes;
        this.zipMap = zipMap;
        this.entryNameByModuleEntry = entryNameByModuleEntry;
    }

    Entry getZipEntry(ModuleEntry entry) {
        Preconditions.checkArgument(this.entryNameByModuleEntry.containsKey(entry), "Module entry %s is not available in pack", (Object)entry);
        return this.zipMap.getEntries().get(this.entryNameByModuleEntry.get(entry));
    }

    boolean hasEntry(ModuleEntry entry) {
        return this.entryNameByModuleEntry.containsKey(entry);
    }

    ZipSource select(ImmutableList<ModuleEntry> moduleEntries, Function<ModuleEntry, String> nameFunction) {
        return this.select(moduleEntries, nameFunction, entry -> 0L);
    }

    ZipSource select(ImmutableList<ModuleEntry> moduleEntries, Function<ModuleEntry, String> nameFunction, ToLongFunction<ModuleEntry> alignmentFunction) {
        ZipSource source = new ZipSource(this.zipMap);
        for (ModuleEntry entry : moduleEntries) {
            Preconditions.checkArgument(this.entryNameByModuleEntry.containsKey(entry), "Module entry %s is not available in the pack.", (Object)entry);
            source.select(this.entryNameByModuleEntry.get(entry), nameFunction.apply(entry), -2, alignmentFunction.applyAsLong(entry));
        }
        return source;
    }

    public ModuleEntriesPack mergeWith(ModuleEntriesPack anotherPack) {
        Preconditions.checkArgument(Collections.disjoint(this.namePrefixes, anotherPack.namePrefixes), "Both packs contain the same name prefix.");
        try {
            long thisSize = Files.size(this.zipMap.getPath());
            long anotherSize = Files.size(anotherPack.zipMap.getPath());
            ModuleEntriesPack to4 = thisSize > anotherSize ? this : anotherPack;
            ModuleEntriesPack from = thisSize > anotherSize ? anotherPack : this;
            try (ZipArchive archive = new ZipArchive(to4.zipMap.getPath());){
                archive.add(ZipSource.selectAll(from.zipMap.getPath()));
            }
            Files.delete(from.zipMap.getPath());
            IdentityHashMap mergedNames = Streams.concat(this.entryNameByModuleEntry.entrySet().stream(), anotherPack.entryNameByModuleEntry.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a15, b15) -> b15, Maps::newIdentityHashMap));
            return new ModuleEntriesPack(Sets.union(to4.namePrefixes, from.namePrefixes).immutableCopy(), ZipMap.from(to4.zipMap.getPath()), mergedNames);
        }
        catch (IOException e15) {
            throw new UncheckedIOException(e15);
        }
    }
}

