/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.ssa.BasicRegisterMapper;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.ssa.back.RegisterAllocator;
import com.android.dx.util.BitIntSet;
import java.util.BitSet;

public class FirstFitAllocator
extends RegisterAllocator {
    private static final boolean PRESLOT_PARAMS = true;
    private final BitSet mapped;

    public FirstFitAllocator(SsaMethod ssaMeth, InterferenceGraph interference) {
        super(ssaMeth, interference);
        this.mapped = new BitSet(ssaMeth.getRegCount());
    }

    @Override
    public boolean wantsParamsMovedHigh() {
        return true;
    }

    @Override
    public RegisterMapper allocateRegisters() {
        int oldRegCount = this.ssaMeth.getRegCount();
        BasicRegisterMapper mapper = new BasicRegisterMapper(oldRegCount);
        int nextNewRegister = 0;
        nextNewRegister = this.ssaMeth.getParamWidth();
        for (int i15 = 0; i15 < oldRegCount; ++i15) {
            if (this.mapped.get(i15)) continue;
            int maxCategory = this.getCategoryForSsaReg(i15);
            BitIntSet current = new BitIntSet(oldRegCount);
            this.interference.mergeInterferenceSet(i15, current);
            boolean isPreslotted = false;
            int newReg = 0;
            if (this.isDefinitionMoveParam(i15)) {
                NormalSsaInsn defInsn = (NormalSsaInsn)this.ssaMeth.getDefinitionForRegister(i15);
                newReg = this.paramNumberFromMoveParam(defInsn);
                mapper.addMapping(i15, newReg, maxCategory);
                isPreslotted = true;
            } else {
                mapper.addMapping(i15, nextNewRegister, maxCategory);
                newReg = nextNewRegister;
            }
            for (int j15 = i15 + 1; j15 < oldRegCount; ++j15) {
                if (this.mapped.get(j15) || this.isDefinitionMoveParam(j15) || current.has(j15) || isPreslotted && maxCategory < this.getCategoryForSsaReg(j15)) continue;
                this.interference.mergeInterferenceSet(j15, current);
                maxCategory = Math.max(maxCategory, this.getCategoryForSsaReg(j15));
                mapper.addMapping(j15, newReg, maxCategory);
                this.mapped.set(j15);
            }
            this.mapped.set(i15);
            if (isPreslotted) continue;
            nextNewRegister += maxCategory;
        }
        return mapper;
    }

    private int paramNumberFromMoveParam(NormalSsaInsn ndefInsn) {
        CstInsn origInsn = (CstInsn)ndefInsn.getOriginalRopInsn();
        return ((CstInteger)origInsn.getConstant()).getValue();
    }
}

